/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.jboss.shrinkwrap.resolver.impl.maven.util.IOUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public class ResourceUtil {
    private static final String CLASSPATH_QUALIFIER = "classpath:";
    private static final String FILE_QUALIFIER = "file:";

    public ResourceUtil() {
        throw new UnsupportedOperationException("Instantiation of ResourceUtil is not supported");
    }

    private static String getLocalResourcePathFromResourceName(String resourceName) {
        URL resourceUrl = SecurityActions.getResource(resourceName);
        Validate.notNull(resourceUrl, resourceName + " doesn't exist or can't be accessed on classpath");
        try {
            File localResource = ResourceUtil.temporaryFile(resourceName);
            localResource.deleteOnExit();
            IOUtil.copyWithClose(resourceUrl.openStream(), new FileOutputStream(localResource));
            return localResource.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to open resource name specified by " + resourceName, e);
        }
    }

    public static String resolvePathByQualifier(String path) {
        if (path.startsWith(CLASSPATH_QUALIFIER)) {
            path = ResourceUtil.getLocalResourcePathFromResourceName(path.replace(CLASSPATH_QUALIFIER, ""));
        } else if (path.startsWith(FILE_QUALIFIER)) {
            path = path.replace(FILE_QUALIFIER, "");
        }
        return path;
    }

    private static File temporaryFile(String resourceName) {
        File tmpDir = new File(SecurityActions.getProperty("java.io.tmpdir"));
        Validate.isWriteableDirectory(tmpDir.getAbsolutePath(), "Unable to access temporary directory at " + tmpDir.getAbsolutePath());
        File localResource = new File(tmpDir, resourceName.replaceAll("/", "-").replaceAll("\\\\", "-").replaceAll(File.pathSeparator, "-").replaceAll("\\s", "-"));
        localResource.deleteOnExit();
        return localResource;
    }
}

