/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.util;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.attachments.InputStreamAttachment;
import org.jboss.seam.mail.core.EmailAttachment;
import org.jboss.seam.mail.core.EmailMessage;
import org.jboss.seam.mail.core.MailException;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;
import org.jboss.seam.mail.util.MailUtility;

public class MessageConverter {
    private EmailMessage emailMessage;

    public static EmailMessage convert(Message m) throws MailException {
        MessageConverter mc = new MessageConverter();
        return mc.convertMessage(m);
    }

    public EmailMessage convertMessage(Message m) throws MailException {
        this.emailMessage = new EmailMessage();
        try {
            this.emailMessage.setFromAddresses(MailUtility.getInternetAddressses(m.getFrom()));
            this.emailMessage.setToAddresses(MailUtility.getInternetAddressses(m.getRecipients(Message.RecipientType.TO)));
            this.emailMessage.setCcAddresses(MailUtility.getInternetAddressses(m.getRecipients(Message.RecipientType.CC)));
            this.emailMessage.setBccAddresses(MailUtility.getInternetAddressses(m.getRecipients(Message.RecipientType.BCC)));
            this.emailMessage.setSubject(m.getSubject());
            this.emailMessage.setMessageId(m.getHeader("Message-ID")[0]);
            this.emailMessage.addHeaders(MailUtility.getHeaders(m.getAllHeaders()));
            if (m.getContentType().toLowerCase().contains("multipart/")) {
                this.addMultiPart((MimeMultipart)m.getContent());
            } else if (m.isMimeType("text/plain")) {
                this.emailMessage.setTextBody((String)m.getContent());
            }
        }
        catch (IOException e) {
            throw new MailException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new MailException((Throwable)e);
        }
        return this.emailMessage;
    }

    private void addMultiPart(MimeMultipart mp) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            BodyPart bp = mp.getBodyPart(i);
            if (bp.getContentType().toLowerCase().contains("multipart/")) {
                this.addMultiPart((MimeMultipart)bp.getContent());
                continue;
            }
            this.addPart(mp.getBodyPart(i));
        }
    }

    private void addPart(BodyPart bp) throws MessagingException, IOException {
        if (bp.getContentType().toLowerCase().contains("multipart/")) {
            this.addMultiPart((MimeMultipart)bp.getContent());
        } else if (bp.getContentType().toLowerCase().contains("text/plain")) {
            this.emailMessage.setTextBody((String)bp.getContent());
        } else if (bp.getContentType().toLowerCase().contains("text/html")) {
            this.emailMessage.setHtmlBody((String)bp.getContent());
        } else if (bp.getContentType().toLowerCase().contains("application/octet-stream")) {
            this.emailMessage.addAttachment((EmailAttachment)new InputStreamAttachment(bp.getFileName(), bp.getContentType(), ContentDisposition.mapValue((String)bp.getDisposition()), bp.getInputStream()));
        }
    }
}

