/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.core;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import org.jboss.seam.mail.api.MailMessage;
import org.jboss.seam.mail.attachments.BaseAttachment;
import org.jboss.seam.mail.attachments.FileAttachment;
import org.jboss.seam.mail.attachments.InputStreamAttachment;
import org.jboss.seam.mail.core.EmailAttachment;
import org.jboss.seam.mail.core.EmailContact;
import org.jboss.seam.mail.core.EmailMessage;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.MailConfig;
import org.jboss.seam.mail.core.MailTransporter;
import org.jboss.seam.mail.core.MailTransporterImpl;
import org.jboss.seam.mail.core.SendFailedException;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;
import org.jboss.seam.mail.core.enumerations.ContentType;
import org.jboss.seam.mail.core.enumerations.EmailMessageType;
import org.jboss.seam.mail.core.enumerations.MessagePriority;
import org.jboss.seam.mail.templating.MailContext;
import org.jboss.seam.mail.templating.TemplateProvider;
import org.jboss.seam.mail.util.EmailAttachmentUtil;
import org.jboss.seam.mail.util.MailUtility;
import org.jboss.solder.core.ExtensionManaged;
import org.jboss.solder.logging.Logger;

public class MailMessageImpl
implements MailMessage {
    private EmailMessage emailMessage;
    private TemplateProvider subjectTemplate;
    private TemplateProvider textTemplate;
    private TemplateProvider htmlTemplate;
    private Map<String, Object> templateContext = new HashMap<String, Object>();
    private boolean templatesMerged;
    private MailTransporter mailTransporter;
    @Inject
    @ExtensionManaged
    private Instance<Session> session;
    @Inject
    private Logger log;

    public MailMessageImpl() {
        this.emailMessage = new EmailMessage();
    }

    public MailMessage from(String ... address) {
        this.emailMessage.addFromAddresses(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage from(InternetAddress emailAddress) {
        this.emailMessage.addFromAddress(emailAddress);
        return this;
    }

    public MailMessage from(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addFromAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage from(Collection<? extends EmailContact> emailContacts) {
        this.emailMessage.addFromAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage replyTo(String ... address) {
        this.emailMessage.addReplyToAddresses(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage replyTo(InternetAddress emailAddress) {
        this.emailMessage.addReplyToAddress(emailAddress);
        return this;
    }

    public MailMessage replyTo(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addReplyToAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage replyTo(Collection<? extends EmailContact> emailContacts) {
        this.emailMessage.addReplyToAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage addHeader(String name, String value) {
        this.emailMessage.addHeader(new Header(name, value));
        return this;
    }

    public MailMessage to(String ... address) {
        this.emailMessage.addToAddresses(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage to(InternetAddress emailAddress) {
        this.emailMessage.addToAddress(emailAddress);
        return this;
    }

    public MailMessage to(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addToAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage to(Collection<? extends EmailContact> emailContacts) {
        this.emailMessage.addToAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage cc(String ... address) {
        this.emailMessage.addCcAddresses(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage cc(InternetAddress emailAddress) {
        this.emailMessage.addCcAddress(emailAddress);
        return this;
    }

    public MailMessage cc(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addCcAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage cc(Collection<? extends EmailContact> emailContacts) {
        this.emailMessage.addCcAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage bcc(String ... address) {
        this.emailMessage.addBccAddresses(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage bcc(InternetAddress emailAddress) {
        this.emailMessage.addBccAddress(emailAddress);
        return this;
    }

    public MailMessage bcc(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addBccAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage bcc(Collection<? extends EmailContact> emailContacts) {
        this.emailMessage.addBccAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage subject(String value) {
        this.emailMessage.setSubject(value);
        return this;
    }

    public MailMessage deliveryReceipt(String address) {
        this.emailMessage.addDeliveryReceiptAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage readReceipt(String address) {
        this.emailMessage.addReadReceiptAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage importance(MessagePriority messagePriority) {
        this.emailMessage.setImportance(messagePriority);
        return this;
    }

    public MailMessage messageId(String messageId) {
        this.emailMessage.setMessageId(messageId);
        return this;
    }

    public MailMessage bodyText(String text) {
        this.emailMessage.setTextBody(text);
        return this;
    }

    public MailMessage bodyHtml(String html) {
        this.emailMessage.setHtmlBody(html);
        return this;
    }

    public MailMessage bodyHtmlTextAlt(String html, String text) {
        this.emailMessage.setTextBody(text);
        this.emailMessage.setHtmlBody(html);
        return this;
    }

    public MailMessage addAttachment(EmailAttachment attachment) {
        this.emailMessage.addAttachment(attachment);
        return this;
    }

    public MailMessage addAttachments(Collection<? extends EmailAttachment> attachments) {
        this.emailMessage.addAttachments(attachments);
        return this;
    }

    public MailMessage addAttachment(String fileName, String mimeType, ContentDisposition contentDispostion, byte[] bytes) {
        this.addAttachment(new BaseAttachment(fileName, mimeType, contentDispostion, bytes));
        return this;
    }

    public MailMessage addAttachment(String fileName, String mimeType, ContentDisposition contentDispostion, InputStream inputStream) {
        this.addAttachment(new InputStreamAttachment(fileName, mimeType, contentDispostion, inputStream));
        return this;
    }

    public MailMessage addAttachment(ContentDisposition contentDispostion, File file) {
        this.addAttachment(new FileAttachment(contentDispostion, file));
        return this;
    }

    public MailMessage iCal(String html, byte[] bytes) {
        this.emailMessage.setType(EmailMessageType.INVITE_ICAL);
        this.emailMessage.setHtmlBody(html);
        this.emailMessage.addAttachment((EmailAttachment)new BaseAttachment(null, "text/calendar;method=CANCEL", ContentDisposition.INLINE, bytes, "urn:content-classes:calendarmessage"));
        return this;
    }

    public MailMessage subject(TemplateProvider subject) {
        this.subjectTemplate = subject;
        return this;
    }

    public MailMessage bodyText(TemplateProvider textBody) {
        this.textTemplate = textBody;
        return this;
    }

    public MailMessage bodyHtml(TemplateProvider htmlBody) {
        this.htmlTemplate = htmlBody;
        return this;
    }

    public MailMessage bodyHtmlTextAlt(TemplateProvider htmlBody, TemplateProvider textBody) {
        this.bodyHtml(htmlBody);
        this.bodyText(textBody);
        return this;
    }

    public MailMessage charset(String charset) {
        this.emailMessage.setCharset(charset);
        return this;
    }

    public MailMessage contentType(ContentType contentType) {
        this.emailMessage.setRootContentType(contentType);
        return this;
    }

    public MailMessage put(String key, Object value) {
        this.templateContext.put(key, value);
        return this;
    }

    public MailMessage put(Map<String, Object> values) {
        this.templateContext.putAll(values);
        return this;
    }

    public EmailMessage getEmailMessage() {
        return this.emailMessage;
    }

    public void setEmailMessage(EmailMessage emailMessage) {
        this.emailMessage = emailMessage;
    }

    public void setMailTransporter(MailTransporter mailTransporter) {
        this.mailTransporter = mailTransporter;
    }

    public EmailMessage mergeTemplates() {
        this.log.debug((Object)"Merging templates");
        this.put("mailContext", new MailContext(EmailAttachmentUtil.getEmailAttachmentMap(this.emailMessage.getAttachments())));
        if (this.subjectTemplate != null) {
            this.emailMessage.setSubject(this.subjectTemplate.merge(this.templateContext));
        }
        if (this.textTemplate != null) {
            this.emailMessage.setTextBody(this.textTemplate.merge(this.templateContext));
        }
        if (this.htmlTemplate != null) {
            this.emailMessage.setHtmlBody(this.htmlTemplate.merge(this.templateContext));
        }
        this.templatesMerged = true;
        return this.emailMessage;
    }

    public EmailMessage send(MailTransporter mailTransporter) throws SendFailedException {
        this.log.debug((Object)"Beginning send");
        if (!this.templatesMerged) {
            this.mergeTemplates();
        }
        try {
            mailTransporter.send(this.emailMessage);
        }
        catch (Exception e) {
            throw new SendFailedException("Send Failed", (Throwable)e);
        }
        return this.emailMessage;
    }

    public EmailMessage send(Session session) throws SendFailedException {
        return this.send(new MailTransporterImpl(session));
    }

    public EmailMessage send(MailConfig mailConfig) {
        return this.send(MailUtility.createSession(mailConfig));
    }

    public EmailMessage send() throws SendFailedException {
        if (this.mailTransporter != null) {
            return this.send(this.mailTransporter);
        }
        return this.send((Session)this.session.get());
    }
}

