/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.attachments;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.seam.mail.attachments.BaseAttachment;
import org.jboss.seam.mail.core.AttachmentException;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;

public class InputStreamAttachment
extends BaseAttachment {
    public InputStreamAttachment(String fileName, String mimeType, ContentDisposition contentDisposition, InputStream inputStream) {
        try {
            super.setFileName(fileName);
            super.setMimeType(mimeType);
            super.setContentDisposition(contentDisposition);
            super.setBytes(ByteStreams.toByteArray((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new AttachmentException("Wasn't able to create email attachment from InputStream");
        }
    }

    public InputStreamAttachment(String fileName, String mimeType, ContentDisposition contentDisposition, InputStream inputStream, String contentClass) {
        this(fileName, mimeType, contentDisposition, inputStream);
        super.addHeader(new Header("Content-Class", contentClass));
    }
}

