/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import jakarta.annotation.Priority;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.EmbeddedServerHelper;
import org.jboss.resteasy.util.PortProvider;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

@Priority(value=150)
public class UndertowJaxrsServer
implements EmbeddedJaxrsServer<UndertowJaxrsServer> {
    protected final PathHandler root = new PathHandler();
    protected final ServletContainer container = ServletContainer.Factory.newInstance();
    protected Undertow server;
    protected DeploymentManager manager;
    protected Map<String, String> contextParams;
    protected Map<String, String> initParams;
    private ResteasyDeployment deployment;
    private int port = PortProvider.getPort();
    private String hostname = "localhost";
    private String rootResourcePath;
    private EmbeddedServerHelper serverHelper = new EmbeddedServerHelper();

    public UndertowJaxrsServer deploy() {
        this.serverHelper.checkDeployment(this.deployment);
        return this.deploy(this.deployment, this.serverHelper.checkContextPath(this.rootResourcePath), this.deployment.getClass().getClassLoader());
    }

    public void start(SeBootstrap.Configuration configuration) {
        this.setHostname(configuration.host()).setPort(configuration.port()).setRootResourcePath(configuration.rootPath());
        Undertow.Builder builder = Undertow.builder().setHandler((HttpHandler)this.root);
        if ("HTTPS".equalsIgnoreCase(configuration.protocol())) {
            builder.addHttpsListener(this.port, this.hostname, configuration.sslContext());
        } else {
            builder.addHttpListener(this.port, this.hostname);
        }
        switch (configuration.sslClientAuthentication()) {
            case NONE: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.NOT_REQUESTED);
                break;
            }
            case OPTIONAL: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
                return;
            }
            case MANDATORY: {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUIRED);
            }
        }
        this.server = builder.build();
        this.server.start();
        this.deploy();
    }

    public UndertowJaxrsServer start() {
        this.server = Undertow.builder().addHttpListener(this.port, this.hostname).setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public void stop() {
        this.server.stop();
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new ResteasyDeploymentImpl();
        }
        return this.deployment;
    }

    public UndertowJaxrsServer setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    public UndertowJaxrsServer setPort(int port) {
        this.port = port;
        return this;
    }

    public UndertowJaxrsServer setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public UndertowJaxrsServer setRootResourcePath(String rootResourcePath) {
        this.rootResourcePath = rootResourcePath;
        return this;
    }

    public UndertowJaxrsServer setSecurityDomain(SecurityDomain sc) {
        return this;
    }

    public UndertowJaxrsServer deploy(Application application) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplication(application);
        return this.deploy((ResteasyDeployment)resteasyDeployment, this.serverHelper.checkAppPath(application.getClass().getAnnotation(ApplicationPath.class)), application.getClass().getClassLoader());
    }

    public UndertowJaxrsServer deploy(Application application, String contextPath) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplication(application);
        resteasyDeployment.start();
        return this.deploy((ResteasyDeployment)resteasyDeployment, this.serverHelper.checkContextPath(contextPath), application.getClass().getClassLoader());
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplicationClass(application.getName());
        return this.deploy((ResteasyDeployment)resteasyDeployment, this.serverHelper.checkAppPath(application.getAnnotation(ApplicationPath.class)), resteasyDeployment.getClass().getClassLoader());
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application, String contextPath) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplicationClass(application.getName());
        return this.deploy((ResteasyDeployment)resteasyDeployment, this.serverHelper.checkContextPath(contextPath), resteasyDeployment.getClass().getClassLoader());
    }

    private UndertowJaxrsServer deploy(ResteasyDeployment resteasyDeployment, String contextPath, ClassLoader clazzLoader) {
        DeploymentInfo di = this.undertowDeployment(resteasyDeployment);
        this.populateDeploymentInfo(di, clazzLoader, contextPath);
        return this.deploy(di);
    }

    public DeploymentInfo undertowDeployment(ResteasyDeployment resteasyDeployment, String mappingPrefix) {
        Object mapping = this.serverHelper.checkContextPath(mappingPrefix);
        if (!((String)mapping).endsWith("/")) {
            mapping = (String)mapping + "/";
        }
        mapping = (String)mapping + "*";
        ServletInfo resteasyServlet = Servlets.servlet((String)"ResteasyServlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping((String)mapping);
        if (!((String)mapping).equals("/*")) {
            String prefix = ((String)mapping).substring(0, ((String)mapping).length() - 2);
            resteasyServlet.addInitParam("resteasy.servlet.mapping.prefix", prefix);
        }
        return new DeploymentInfo().addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)resteasyDeployment).addServlet(resteasyServlet);
    }

    public DeploymentInfo undertowDeployment(ResteasyDeployment resteasyDeployment) {
        return this.undertowDeployment(resteasyDeployment, this.serverHelper.checkAppDeployment(resteasyDeployment));
    }

    public DeploymentInfo undertowDeployment(Class<? extends Application> application) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplicationClass(application.getName());
        DeploymentInfo di = this.undertowDeployment((ResteasyDeployment)resteasyDeployment, this.serverHelper.checkAppPath(application.getAnnotation(ApplicationPath.class)));
        di.setClassLoader(application.getClassLoader());
        return di;
    }

    public void addResourcePrefixPath(String path, ResourceHandler handler) {
        this.root.addPrefixPath(path, (HttpHandler)handler);
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment resteasyDeployment) {
        return this.deploy(resteasyDeployment, this.serverHelper.checkContextPath(this.rootResourcePath), resteasyDeployment.getClass().getClassLoader());
    }

    public UndertowJaxrsServer deploy(DeploymentInfo builder) {
        this.manager = this.container.addDeployment(this.configureDefaults(builder, this.getDeployment()));
        this.manager.deploy();
        try {
            this.root.addPrefixPath(builder.getContextPath(), this.manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public UndertowJaxrsServer start(Undertow.Builder builder) {
        this.server = builder.setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public DeploymentManager getManager() {
        return this.manager;
    }

    public Map<String, String> getContextParams() {
        if (this.contextParams == null) {
            this.contextParams = new HashMap<String, String>();
        }
        return this.contextParams;
    }

    public UndertowJaxrsServer setContextParams(Map<String, String> contextParams) {
        this.contextParams = contextParams;
        return this;
    }

    public Map<String, String> getInitParams() {
        if (this.initParams == null) {
            this.initParams = new HashMap<String, String>();
        }
        return this.initParams;
    }

    public UndertowJaxrsServer setInitParams(Map<String, String> initParams) {
        this.initParams = initParams;
        return this;
    }

    public UndertowJaxrsServer deployOldStyle(Class<? extends Application> application) {
        return this.deployOldStyle(application, this.serverHelper.checkAppPath(application.getAnnotation(ApplicationPath.class)));
    }

    public UndertowJaxrsServer deployOldStyle(Class<? extends Application> application, String ctxtPath) {
        ResteasyDeploymentImpl resteasyDeployment = new ResteasyDeploymentImpl();
        resteasyDeployment.setApplicationClass(application.getName());
        String contextPath = this.serverHelper.checkContextPath(ctxtPath);
        DeploymentInfo di = this.undertowDeployment((ResteasyDeployment)resteasyDeployment, "/");
        this.populateDeploymentInfo(di, resteasyDeployment.getClass().getClassLoader(), contextPath);
        return this.deploy(di);
    }

    private void populateDeploymentInfo(DeploymentInfo di, ClassLoader clazzLoader, String contextPath) {
        di.setClassLoader(clazzLoader);
        di.setContextPath(contextPath);
        di.setDeploymentName("Resteasy" + contextPath);
        if (this.contextParams != null) {
            for (Map.Entry<String, String> e : this.contextParams.entrySet()) {
                di.addInitParameter(e.getKey(), e.getValue());
            }
        }
        if (this.initParams != null) {
            ServletInfo servletInfo = (ServletInfo)di.getServlets().get("ResteasyServlet");
            for (Map.Entry<String, String> e : this.initParams.entrySet()) {
                servletInfo.addInitParam(e.getKey(), e.getValue());
            }
        }
    }

    private DeploymentInfo configureDefaults(DeploymentInfo deploymentInfo, ResteasyDeployment deployment) {
        MultipartConfig multipartConfig;
        Application application;
        if (deploymentInfo.getDefaultMultipartConfig() == null && (application = deployment.getApplication()) != null && (multipartConfig = application.getClass().getAnnotation(MultipartConfig.class)) != null) {
            deploymentInfo.setDefaultMultipartConfig(new MultipartConfigElement(multipartConfig));
        }
        return deploymentInfo;
    }
}

