/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.EntityTypeFactory;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.client.core.ClientInterceptorRepositoryImpl;
import org.jboss.resteasy.client.core.marshallers.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.marshallers.Marshaller;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInvoker
extends ClientInterceptorRepositoryImpl {
    protected ResteasyProviderFactory providerFactory;
    protected String httpMethod;
    protected UriBuilderImpl uri;
    protected Method method;
    protected Class declaring;
    protected MediaType accepts;
    protected Marshaller[] marshallers;
    protected ClientExecutor executor;
    protected boolean followRedirects;

    public ClientInvoker(URI baseUri, Class declaring, Method method, ResteasyProviderFactory providerFactory, ClientExecutor executor) {
        this.declaring = declaring;
        this.method = method;
        this.marshallers = ClientMarshallerFactory.createMarshallers(declaring, method, providerFactory);
        this.providerFactory = providerFactory;
        this.executor = executor;
        this.accepts = MediaTypeHelper.getProduces(declaring, method);
        this.uri = new UriBuilderImpl();
        this.uri.uri(baseUri);
        if (declaring.isAnnotationPresent(Path.class)) {
            this.uri.path(declaring);
        }
        if (method.isAnnotationPresent(Path.class)) {
            this.uri.path(method);
        }
    }

    public MediaType getAccepts() {
        return this.accepts;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getDeclaring() {
        return this.declaring;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] args) {
        boolean isProvidersSet;
        boolean bl = isProvidersSet = ResteasyProviderFactory.getContextData(Providers.class) != null;
        if (!isProvidersSet) {
            ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        }
        try {
            Object extractedEntity;
            if (this.uri == null) {
                throw new RuntimeException("You have not set a base URI for the client proxy");
            }
            ClientRequest request = new ClientRequest(this.uri, this.executor, this.providerFactory);
            if (this.accepts != null) {
                request.header("Accept", this.accepts.toString());
            }
            this.copyClientInterceptorsTo(request);
            boolean isClientResponseResult = ClientResponse.class.isAssignableFrom(this.method.getReturnType());
            request.followRedirects(!isClientResponseResult || this.followRedirects);
            for (int i = 0; i < this.marshallers.length; ++i) {
                this.marshallers[i].build(request, args[i]);
            }
            BaseClientResponse clientResponse = null;
            try {
                clientResponse = (BaseClientResponse)request.httpMethod(this.httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            clientResponse.setAttributeExceptionsTo(this.method.toString());
            Object object = extractedEntity = this.extractEntity(clientResponse);
            return object;
        }
        finally {
            if (!isProvidersSet) {
                ResteasyProviderFactory.popContextData(Providers.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractEntity(BaseClientResponse clientResponse) {
        clientResponse.setAnnotations(this.method.getAnnotations());
        Class<?> returnType = this.method.getReturnType();
        if (ClientResponse.class.isAssignableFrom(returnType)) {
            Type methodGenericReturnType = this.method.getGenericReturnType();
            if (methodGenericReturnType instanceof ParameterizedType) {
                ParameterizedType zType = (ParameterizedType)methodGenericReturnType;
                Type genericReturnType = zType.getActualTypeArguments()[0];
                clientResponse.setReturnType(Types.getRawType(genericReturnType));
                clientResponse.setGenericReturnType(genericReturnType);
            }
            return clientResponse;
        }
        if (returnType.equals(Response.Status.class)) {
            clientResponse.releaseConnection();
            return clientResponse.getResponseStatus();
        }
        if (Response.class.isAssignableFrom(returnType)) {
            ClientResponseType responseHint = this.method.getAnnotation(ClientResponseType.class);
            if (responseHint != null) {
                this.handleResponseHint(clientResponse, responseHint);
            }
            return clientResponse;
        }
        try {
            clientResponse.checkFailureStatus();
        }
        catch (RuntimeException e) {
            this.clientErrorHandling(clientResponse, e);
        }
        boolean releaseConnectionAfter = true;
        try {
            if (returnType == null || this.isVoidReturnType(returnType)) {
                clientResponse.releaseConnection();
                Object zType = null;
                return zType;
            }
            clientResponse.setReturnType(returnType);
            clientResponse.setGenericReturnType(this.method.getGenericReturnType());
            Object obj = clientResponse.getEntity();
            if (obj instanceof InputStream) {
                releaseConnectionAfter = false;
            }
            Object t = obj;
            return t;
        }
        catch (RuntimeException e) {
            this.clientErrorHandling(clientResponse, e);
        }
        finally {
            if (releaseConnectionAfter) {
                clientResponse.releaseConnection();
            }
        }
        throw new RuntimeException("Should be unreachable");
    }

    protected void clientErrorHandling(BaseClientResponse clientResponse, RuntimeException e) {
        for (ClientErrorInterceptor handler : this.providerFactory.getClientErrorInterceptors()) {
            try {
                InputStream stream = clientResponse.getStreamFactory().getInputStream();
                if (stream != null) {
                    stream.reset();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            handler.handle(clientResponse);
        }
        throw e;
    }

    private boolean isVoidReturnType(Class<?> returnType) {
        return Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }

    private void handleResponseHint(BaseClientResponse clientResponse, ClientResponseType responseHint) {
        Class returnType = responseHint.entityType();
        Class<? extends EntityTypeFactory> entityTypeFactory = responseHint.entityTypeFactory();
        if (this.isVoidReturnType(returnType)) {
            EntityTypeFactory factory = null;
            try {
                factory = entityTypeFactory.newInstance();
            }
            catch (InstantiationException e) {
                throw clientResponse.createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName());
            }
            catch (IllegalAccessException e) {
                throw clientResponse.createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName() + ". " + e.getMessage());
            }
            returnType = factory.getEntityType(clientResponse.getStatus(), clientResponse.getMetadata());
        }
        if (!this.isVoidReturnType(returnType)) {
            clientResponse.setReturnType(returnType);
        }
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void followRedirects() {
        this.setFollowRedirects(true);
    }
}

