/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ClassUtil;

public class CompressedClassBytes
extends ClassBytes
implements Externalizable {
    static final long serialVersionUID = 5984363018051268886L;
    private static final boolean DEBUG = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new Boolean(Boolean.getBoolean("jboss.remoting.compression.debug"));
        }
    });
    private static final int MIN_COMPRESS = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Integer.getInteger("jboss.remoting.compression.min", 1000);
        }
    });
    private int compressionLevel;
    private int compressedSize;
    private int originalSize;
    static final int VERSION_5_0 = 500;
    static final int CURRENT_VERSION = 500;

    public CompressedClassBytes() {
        super(null, null);
    }

    public CompressedClassBytes(String className, byte[] data, int compressionLevel) {
        super(className, data);
        this.compressionLevel = compressionLevel;
    }

    public static void main(String[] args) {
        try {
            String string = new String("Hello,world - this is a test of compression, not sure what will happen. alskjfdalksjflkajsdfljaslkfjaslkdjflksajflkajsfdlkjsalkfjaslkfdjlksajflkasjfdlkajslkfjsalkfjasldfjlksadjflkasjfdlkajdsf");
            byte[] buf = ClassUtil.serialize(string);
            CompressedClassBytes cb = new CompressedClassBytes("java.lang.String", buf, 9);
            byte[] b1 = ClassUtil.serialize(cb);
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            Object obj = ClassUtil.deserialize(b1, classLoader);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 500: {
                this.compressionLevel = in.readInt();
                this.originalSize = in.readInt();
                this.compressedSize = in.readInt();
                byte[] buf = new byte[this.compressedSize];
                int count = in.read(buf, 0, this.compressedSize);
                this.classBytes = this.compressedSize != this.originalSize ? this.uncompress(buf) : buf;
                if (DEBUG) {
                    System.err.println("<< reading compressed: " + this.compressedSize + ", original: " + this.originalSize + ", compressionLevel:" + this.compressionLevel);
                }
                this.className = (String)in.readObject();
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown version seen: " + version);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(500);
        out.writeInt(this.compressionLevel);
        out.writeInt(this.classBytes.length);
        byte[] compressed = this.compress(this.classBytes);
        out.writeInt(compressed.length);
        out.write(compressed);
        out.writeObject(this.className);
        out.flush();
    }

    public byte[] compress(byte[] input) {
        if (input.length < MIN_COMPRESS) {
            return input;
        }
        Deflater deflater = new Deflater(this.compressionLevel);
        deflater.setInput(input, 0, input.length);
        deflater.finish();
        byte[] buff = new byte[input.length + 50];
        deflater.deflate(buff);
        int compressedSize = deflater.getTotalOut();
        if (deflater.getTotalIn() != input.length) {
            if (DEBUG) {
                System.err.println(">> Attempting compression and the data didn't compress well, returning original");
            }
            return input;
        }
        if (compressedSize >= input.length - 4) {
            if (DEBUG) {
                System.err.println(">> Compressed size is larger than original .. ?");
            }
            return input;
        }
        byte[] output = new byte[compressedSize + 4];
        System.arraycopy(buff, 0, output, 4, compressedSize);
        output[0] = (byte)(input.length >> 24);
        output[1] = (byte)(input.length >> 16);
        output[2] = (byte)(input.length >> 8);
        output[3] = (byte)input.length;
        if (DEBUG) {
            System.err.println(">> writing compressed: " + output.length + ", original: " + this.classBytes.length + ", compressionLevel:" + this.compressionLevel);
        }
        return output;
    }

    public byte[] uncompress(byte[] input) throws IOException {
        try {
            int uncompressedSize = ((input[0] & 0xFF) << 24) + ((input[1] & 0xFF) << 16) + ((input[2] & 0xFF) << 8) + (input[3] & 0xFF);
            Inflater inflater = new Inflater();
            inflater.setInput(input, 4, input.length - 4);
            inflater.finished();
            byte[] out = new byte[uncompressedSize];
            inflater.inflate(out);
            inflater.reset();
            return out;
        }
        catch (DataFormatException e) {
            throw new IOException("Input Stream is corrupt: " + e);
        }
    }
}

