/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.rmi.MarshalException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Version;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackPoller;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.stream.StreamServer;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.local.LocalClientInvoker;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.id.GUID;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;

public class Client
implements Externalizable {
    public static final String ONEWAY_FLAG = "oneway";
    public static final String LISTENER_ID_KEY = "listenerId";
    public static final int MAX_NUM_ONEWAY_THREADS_DEFAULT = 10;
    public static final String RAW = "rawPayload";
    public static final String ENABLE_LEASE = "enableLease";
    public static final String HANDSHAKE_COMPLETED_LISTENER = "handshakeCompletedListener";
    public static final String CALLBACK_SERVER_PROTOCOL = "callbackServerProtocol";
    public static final String CALLBACK_SERVER_HOST = "callbackServerHost";
    public static final String CALLBACK_SERVER_PORT = "callbackServerPort";
    public static final String MAX_NUM_ONEWAY_THREADS = "maxNumThreadsOneway";
    public static final String MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE = "maxOnewayThreadPoolQueueSize";
    public static final int DEFAULT_DISCONNECT_TIMEOUT = -1;
    public static final String INVOKER_DESTRUCTION_DELAY = "invokerDestructionDelay";
    public static final String THROW_CALLBACK_EXCEPTION = "throwCallbackException";
    private static Map connectionValidators = new HashMap();
    private static Object connectionValidatorLock = new Object();
    static final String CLIENT = "client";
    static final String CONNECTION_LISTENER = "connectionListener";
    public static final String USE_ALL_PARAMS = "useAllParams";
    private static final Logger log = Logger.getLogger((Class)Client.class);
    private static boolean trace = log.isTraceEnabled();
    private static final long serialVersionUID = 5679279425009837934L;
    private static Timer invokerDestructionTimer;
    private static Object invokerDestructionTimerLock;
    private static int clientCounter;
    private static final InetAddress LOCAL_HOST;
    private int maxNumberThreads = 10;
    private int maxOnewayThreadPoolQueueSize = -1;
    private ClientInvoker invoker;
    private ClassLoader classloader;
    private String subsystem;
    private String sessionId;
    private Object onewayThreadPoolLock = new Object();
    private ThreadPool onewayThreadPool;
    private InvokerLocator locator;
    private ConnectionValidator connectionValidator = null;
    private ConnectionValidatorKey connectionValidatorKey;
    private Map configuration = new HashMap();
    private Map callbackConnectors = new HashMap();
    private Map callbackPollers = new HashMap();
    private Map listeners = new HashMap();
    private SocketFactory socketFactory;
    private int disconnectTimeout = -1;
    private boolean connected = false;
    private int invokerDestructionDelay = 0;
    private Set connectionListeners = new HashSet();
    private boolean useClientConnectionIdentity;
    private boolean useServerConnectionIdentity;

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return Client.doGetLocalHost();
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return Client.doGetLocalHost();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static InetAddress doGetLocalHost() throws UnknownHostException {
        if (LOCAL_HOST != null) {
            return LOCAL_HOST;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return InetAddress.getByName("127.0.0.1");
        }
    }

    public Client() {
    }

    public Client(InvokerLocator locator) throws Exception {
        this(locator, null, null);
    }

    public Client(InvokerLocator locator, Map configuration) throws Exception {
        this(locator, null, configuration);
    }

    public Client(InvokerLocator locator, String subsystem) throws Exception {
        this(locator, subsystem, null);
    }

    public Client(InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this(null, locator, subsystem, configuration);
    }

    public Client(ClassLoader cl, InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this.classloader = cl == null ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        }) : cl;
        this.locator = locator;
        String string = this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        if (configuration != null) {
            this.configuration = new HashMap(configuration);
        }
        this.sessionId = new GUID().toString();
        this.processParameters();
    }

    public Client(ClassLoader cl, ClientInvoker invoker, String subsystem) throws Exception {
        this.classloader = cl;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.invoker = invoker;
        this.sessionId = new GUID().toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 2: 
            case 22: {
                this.locator = (InvokerLocator)in.readObject();
                this.subsystem = (String)in.readObject();
                this.configuration = (Map)in.readObject();
                boolean wasConnected = in.readBoolean();
                this.classloader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                try {
                    try {
                        this.invoker = (ClientInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return InvokerRegistry.createClientInvoker(Client.this.locator, Client.this.configuration);
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    if (!wasConnected) break;
                    this.connect();
                    break;
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    throw new IOException(e.getMessage());
                }
            }
            default: {
                throw new StreamCorruptedException("Unkown version seen: " + version);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(Version.getDefaultVersion());
        out.writeObject(this.invoker != null ? this.invoker.getLocator() : this.locator);
        out.writeObject(this.subsystem);
        out.writeObject(this.configuration);
        out.writeBoolean(this.isConnected());
        out.flush();
    }

    public void addConnectionListener(ConnectionListener listener) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.configuration.get("validatorPingPeriod") == null && this.locator.getParameters().get("validatorPingPeriod") == null) {
            String pingPeriod = Long.toString(2000L);
            metadata.put("validatorPingPeriod", pingPeriod);
        }
        this.addConnectionListener(listener, metadata);
    }

    public void addConnectionListener(ConnectionListener listener, int pingPeriod) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("validatorPingPeriod", Integer.toString(pingPeriod));
        this.addConnectionListener(listener, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener, Map metadata) {
        if (this.invoker == null) {
            throw new RuntimeException("Can not add connection listener to remoting client while client is not connected.");
        }
        if (this.invoker instanceof LocalClientInvoker) {
            return;
        }
        Object object = connectionValidatorLock;
        synchronized (object) {
            if (trace) {
                log.trace((Object)(this + " in addConnectionListener()"));
            }
            if (this.connectionValidator == null) {
                HashMap map = new HashMap(this.configuration);
                map.putAll(metadata);
                this.connectionValidatorKey = new ConnectionValidatorKey(this.invoker, map);
                WeakReference ref = (WeakReference)connectionValidators.get(this.connectionValidatorKey);
                if (ref == null) {
                    this.connectionValidator = new ConnectionValidator(this, metadata);
                    connectionValidators.put(this.connectionValidatorKey, new WeakReference<ConnectionValidator>(this.connectionValidator));
                    this.connectionValidator.addConnectionListener(this, listener);
                    if (trace) {
                        log.trace((Object)(this + ": created " + this.connectionValidator));
                    }
                } else {
                    this.connectionValidator = (ConnectionValidator)ref.get();
                    if (this.connectionValidator.addConnectionListener(this, listener)) {
                        if (trace) {
                            log.trace((Object)(this + ": reusing from static table:  " + this.connectionValidator));
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)(this + ": unable to reuse existing ConnectionValidator in static map: " + this.connectionValidator));
                        }
                        this.connectionValidator = new ConnectionValidator(this, metadata);
                        connectionValidators.put(this.connectionValidatorKey, new WeakReference<ConnectionValidator>(this.connectionValidator));
                        this.connectionValidator.addConnectionListener(this, listener);
                        if (trace) {
                            log.trace((Object)(this + ": current ConnectionValidator is stopped: created " + this.connectionValidator));
                        }
                    }
                }
            } else if (this.connectionValidator.addConnectionListener(this, listener)) {
                if (trace) {
                    log.trace((Object)(this + ": reusing from local reference: " + this.connectionValidator));
                }
            } else {
                if (trace) {
                    log.trace((Object)(this + ": unable to reuse ConnectionValidator from local reference: " + this.connectionValidator));
                }
                this.connectionValidator = new ConnectionValidator(this, metadata);
                connectionValidators.put(this.connectionValidatorKey, new WeakReference<ConnectionValidator>(this.connectionValidator));
                this.connectionValidator.addConnectionListener(this, listener);
                if (trace) {
                    log.trace((Object)(this + ": current ConnectionValidator is stopped: created " + this.connectionValidator));
                }
            }
            this.connectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnectionListener(ConnectionListener listener) {
        if (trace) {
            log.trace((Object)(this + ".removeConnectionListener(" + listener + ")"));
        }
        boolean isRemoved = false;
        Object object = connectionValidatorLock;
        synchronized (object) {
            if (this.connectionValidator == null) {
                return false;
            }
            isRemoved = this.connectionValidator.removeConnectionListener(this, listener);
            if (this.connectionValidator.isStopped()) {
                if (connectionValidators.remove(this.connectionValidatorKey) != null) {
                    log.debug((Object)(this + ".removeConnectionListener() removed from static map: " + this.connectionValidator));
                }
                this.connectionValidator = null;
                this.connectionValidatorKey = null;
            }
            this.connectionListeners.remove(listener);
            if (this.connectionListeners.isEmpty()) {
                this.connectionValidator = null;
                this.connectionValidatorKey = null;
            }
            if (this.connectionValidator == null && trace) {
                log.trace((Object)(this + " set connectionValidator to null"));
            }
        }
        return isRemoved;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() throws Exception {
        this.connect(null, null);
    }

    public void connect(ConnectionListener listener) throws Exception {
        this.connect(listener, null);
    }

    public void connect(ConnectionListener listener, Map metadata) throws Exception {
        log.debug((Object)(this + ".connect(" + listener + ")"));
        if (trace) {
            log.trace((Object)(this + ": metadata = " + metadata));
        }
        if (this.isConnected()) {
            return;
        }
        if (this.locator == null) {
            throw new IllegalStateException("Cannot connect a client with a null locator");
        }
        if (this.invoker == null) {
            if (this.socketFactory != null) {
                this.configuration.put("customSocketFactory", this.socketFactory);
                this.socketFactory = null;
            }
            try {
                this.invoker = (ClientInvoker)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return InvokerRegistry.createClientInvoker(Client.this.locator, Client.this.configuration);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        this.connect(this.invoker, listener, metadata);
        this.connected = true;
        log.debug((Object)(this + " is connected"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object;
        if (trace) {
            log.trace((Object)(this + " entering disconnect()"));
        }
        this.connected = false;
        if (this.invoker != null) {
            this.invoker.terminateLease(this.sessionId, this.disconnectTimeout);
            if (this.invokerDestructionDelay > 0) {
                object = invokerDestructionTimerLock;
                synchronized (object) {
                    InvokerDestructionTimerTask task = new InvokerDestructionTimerTask(this.invoker, this.configuration);
                    if (invokerDestructionTimer == null) {
                        invokerDestructionTimer = new Timer(true);
                    }
                    try {
                        invokerDestructionTimer.schedule((TimerTask)task, this.invokerDestructionDelay);
                    }
                    catch (IllegalStateException e) {
                        log.debug((Object)"Unable to schedule InvokerDestructionTimerTask on existing Timer", (Throwable)e);
                        invokerDestructionTimer = new Timer(true);
                        invokerDestructionTimer.schedule((TimerTask)task, this.invokerDestructionDelay);
                    }
                    if (trace) {
                        log.trace((Object)(this + " scheduled destruction of " + this.invoker));
                    }
                }
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InvokerRegistry.destroyClientInvoker(Client.this.invoker.getLocator(), Client.this.configuration);
                    return null;
                }
            });
            this.invoker = null;
        }
        object = connectionValidatorLock;
        synchronized (object) {
            if (this.connectionValidator != null) {
                Iterator it = this.connectionListeners.iterator();
                while (it.hasNext()) {
                    ConnectionListener listener = (ConnectionListener)it.next();
                    this.connectionValidator.removeConnectionListener(this, listener);
                }
                if (this.connectionValidator.isStopped() && connectionValidators.remove(this.connectionValidatorKey) != null && trace) {
                    log.trace((Object)(this + ".disconnect() removed from static map: " + this.connectionValidator));
                }
                this.connectionValidator = null;
                this.connectionValidatorKey = null;
            }
        }
        log.debug((Object)(this + " is disconnected"));
    }

    public ClientInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClientInvoker invoker) {
        this.invoker = invoker;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public Object invoke(Object param) throws Throwable {
        return this.invoke(param, null);
    }

    public Object invoke(Object param, Map metadata) throws Throwable {
        return this.invoke(param, metadata, null);
    }

    public void invokeOneway(final Object param, Map sendPayload, boolean clientSide) throws Throwable {
        final Map internalSendPayload = sendPayload == null ? new HashMap() : sendPayload;
        internalSendPayload.put(ONEWAY_FLAG, "true");
        if (clientSide) {
            ThreadPool threadPool = this.getOnewayThreadPool();
            Runnable onewayRun = new Runnable(){

                public void run() {
                    try {
                        Client.this.invoke(param, internalSendPayload);
                    }
                    catch (Throwable e) {
                        log.error((Object)("Error executing client oneway invocation request: " + param), e);
                    }
                }
            };
            threadPool.run(onewayRun);
        } else {
            OnewayInvocation invocation = new OnewayInvocation(param);
            this.invoke(invocation, internalSendPayload);
        }
    }

    public Set getCallbackConnectors(InvokerCallbackHandler callbackHandler) {
        return (Set)this.callbackConnectors.get(callbackHandler);
    }

    public int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(int disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public void setMaxOnewayThreadPoolQueueSize(int maxOnewayThreadPoolQueueSize) {
        this.maxOnewayThreadPoolQueueSize = maxOnewayThreadPoolQueueSize;
    }

    public int getMaxOnewayThreadPoolQueueSize() {
        return this.maxOnewayThreadPoolQueueSize;
    }

    public void setMaxNumberOfThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfThreads() {
        return this.maxNumberThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getOnewayThreadPool() {
        Object object = this.onewayThreadPoolLock;
        synchronized (object) {
            if (this.onewayThreadPool == null) {
                BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
                log.debug((Object)("created new thread pool: " + pool));
                Object param = this.configuration.get(MAX_NUM_ONEWAY_THREADS);
                if (param instanceof String) {
                    try {
                        this.maxNumberThreads = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("maxNumberThreads parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.error((Object)("maxNumberThreads parameter must be a string in integer format: " + param));
                }
                if ((param = this.configuration.get(MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE)) instanceof String) {
                    try {
                        this.maxOnewayThreadPoolQueueSize = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("maxOnewayThreadPoolQueueSize parameter has invalid format: " + param));
                    }
                } else if (param != null) {
                    log.error((Object)("maxOnewayThreadPoolQueueSize parameter must be a string in integer format: " + param));
                }
                pool.setMaximumPoolSize(this.maxNumberThreads);
                if (this.maxOnewayThreadPoolQueueSize > 0) {
                    pool.setMaximumQueueSize(this.maxOnewayThreadPoolQueueSize);
                }
                pool.setBlockingMode(BlockingMode.RUN);
                this.onewayThreadPool = pool;
            }
        }
        return this.onewayThreadPool;
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        if (this.isConnected()) {
            throw new RuntimeException("Cannot set socket factory on Client after the connect() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setSocketFactory(socketFactory);
        } else {
            this.socketFactory = socketFactory;
        }
    }

    public SocketFactory getSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getSocketFactory();
        }
        return this.socketFactory;
    }

    public void invokeOneway(Object param) throws Throwable {
        this.invokeOneway(param, null);
    }

    public void invokeOneway(Object param, Map sendPayload) throws Throwable {
        this.invokeOneway(param, sendPayload, false);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata) throws Throwable {
        this.addListener(callbackhandler, metadata, null);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) throws Throwable {
        this.addListener(callbackhandler, metadata, callbackHandlerObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject, boolean serverToClient) throws Throwable {
        InvokerLocator callbackLocator = null;
        if (!this.isConnected()) throw new Exception("Can not add callback listener because remoting client is not connected to server.");
        if (callbackhandler == null) throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        boolean isBidirectional = this.invoker instanceof BidirectionalClientInvoker;
        if (isBidirectional || serverToClient) {
            String transport = null;
            String host = null;
            int port = -1;
            if (metadata != null) {
                transport = (String)metadata.get(CALLBACK_SERVER_PROTOCOL);
                host = (String)metadata.get(CALLBACK_SERVER_HOST);
                String sPort = (String)metadata.get(CALLBACK_SERVER_PORT);
                if (sPort != null) {
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Could not set the internal callback server port as configuration value (" + sPort + ") is not a number."));
                    }
                }
            } else {
                metadata = new HashMap();
            }
            if (transport == null) {
                transport = this.invoker instanceof LocalClientInvoker ? "local" : this.invoker.getLocator().getProtocol();
                metadata.put(CALLBACK_SERVER_PROTOCOL, transport);
            }
            if (host == null) {
                host = Client.getLocalHost().getHostAddress();
                metadata.put(CALLBACK_SERVER_HOST, host);
            }
            if (port == -1) {
                port = PortUtil.findFreePort(host);
                metadata.put(CALLBACK_SERVER_PORT, String.valueOf(port));
            }
            callbackLocator = isBidirectional ? ((BidirectionalClientInvoker)this.invoker).getCallbackLocator(metadata) : new InvokerLocator(transport, host, port, null, metadata);
            log.debug((Object)("starting callback Connector: " + callbackLocator));
            HashMap callbackConfig = new HashMap(this.configuration);
            if (this.locator.getParameters() != null) {
                callbackConfig.putAll(this.locator.getParameters());
            }
            this.configureCallbackServerSocketFactory(callbackConfig);
            Connector callbackServerConnector = new Connector(callbackLocator, callbackConfig);
            Map map = this.callbackConnectors;
            synchronized (map) {
                HashSet<Connector> connectors = (HashSet<Connector>)this.callbackConnectors.get(callbackhandler);
                if (connectors == null) {
                    connectors = new HashSet<Connector>();
                }
                connectors.add(callbackServerConnector);
                this.callbackConnectors.put(callbackhandler, connectors);
            }
            callbackServerConnector.start();
            callbackLocator = callbackServerConnector.getServerInvoker().getLocator();
            this.addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
            return;
        }
        if (this.callbackPollers.get(callbackhandler) != null) {
            log.debug((Object)(callbackhandler + " already registered"));
            return;
        }
        CallbackPoller poller = new CallbackPoller(this, callbackhandler, metadata, callbackHandlerObject);
        this.callbackPollers.put(callbackhandler, poller);
        this.addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
        poller.start();
    }

    public void addListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        this.addListener(callbackHandler, (InvokerLocator)null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator) throws Throwable {
        this.addListener(callbackHandler, clientLocator, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject) throws Throwable {
        if (callbackHandler != null) {
            if (!this.isConnected()) {
                throw new Exception("Can not add callback listener as remoting client is not connected to server.");
            }
        } else {
            throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        }
        this.addCallbackListener(callbackHandler, null, clientLocator, callbackHandlerObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        if (!this.isConnected()) throw new Exception("Can not remove callback listener as remoting client is not connected to server.");
        if (callbackHandler == null) throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
        String listenerId = (String)this.listeners.get(callbackHandler);
        if (listenerId != null) {
            CallbackPoller callbackPoller;
            if (this.disconnectTimeout != 0) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put(LISTENER_ID_KEY, listenerId);
                if (this.disconnectTimeout > 0) {
                    metadata.put("timeout", Integer.toString(this.disconnectTimeout));
                }
                try {
                    this.invoke(new InternalInvocation("removeListener", null), metadata);
                }
                catch (Exception e) {
                    log.debug((Object)"unable to remove remote callback handler", (Throwable)e);
                }
            }
            if ((callbackPoller = (CallbackPoller)this.callbackPollers.remove(callbackHandler)) != null) {
                callbackPoller.stop();
            }
            this.listeners.remove(callbackHandler);
        } else {
            List holderList = this.invoker.getClientLocators(this.sessionId, callbackHandler);
            if (holderList != null && holderList.size() > 0) {
                for (int x = 0; x < holderList.size(); ++x) {
                    AbstractInvoker.CallbackLocatorHolder holder = (AbstractInvoker.CallbackLocatorHolder)holderList.get(x);
                    listenerId = holder.getListenerId();
                    InvokerLocator locator = holder.getLocator();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    metadata.put(LISTENER_ID_KEY, listenerId);
                    if (this.disconnectTimeout != 0) {
                        if (this.disconnectTimeout > 0) {
                            metadata.put("timeout", Integer.toString(this.disconnectTimeout));
                        }
                        try {
                            InternalInvocation ii = new InternalInvocation("removeListener", null);
                            this.invoke(ii, metadata);
                        }
                        catch (Exception e) {
                            log.debug((Object)"unable to remove remote callback handler", (Throwable)e);
                        }
                    }
                    Client client = new Client(locator, this.subsystem);
                    client.setSessionId(this.getSessionId());
                    client.connect();
                    InternalInvocation ii = new InternalInvocation("removeClientListener", new Object[]{callbackHandler});
                    client.invoke(ii, metadata);
                    client.disconnect();
                }
            }
        }
        Set connectors = null;
        Map x = this.callbackConnectors;
        synchronized (x) {
            connectors = (Set)this.callbackConnectors.remove(callbackHandler);
        }
        if (connectors == null) return;
        Iterator it = connectors.iterator();
        while (it.hasNext()) {
            Connector callbackConnector = (Connector)it.next();
            callbackConnector.stop();
            callbackConnector.destroy();
        }
    }

    public List getCallbacks(InvokerCallbackHandler callbackHandler) throws Throwable {
        return this.getCallbacks(callbackHandler, null);
    }

    public List getCallbacks(InvokerCallbackHandler callbackHandler, Map metadata) throws Throwable {
        if (callbackHandler != null) {
            String listenerId = (String)this.listeners.get(callbackHandler);
            if (listenerId != null) {
                if (metadata == null) {
                    metadata = new HashMap<String, String>();
                }
                metadata.put(LISTENER_ID_KEY, listenerId);
                InternalInvocation invocation = new InternalInvocation("getCallbacks", null);
                try {
                    List response;
                    List list = response = (List)this.invoke(invocation, metadata);
                    return list;
                }
                catch (MarshalException e) {
                    if (e.getCause() != null && e.getCause() instanceof SocketTimeoutException) {
                        if (trace) {
                            log.trace((Object)(this + ": getCallbacks() timed out: returning empty list"));
                        }
                        ArrayList arrayList = new ArrayList();
                        return arrayList;
                    }
                    throw e;
                }
                finally {
                    metadata.remove(LISTENER_ID_KEY);
                }
            }
            String errorMessage = "Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler has been registered as listener.";
            String errorMode = (String)metadata.get(THROW_CALLBACK_EXCEPTION);
            boolean throwError = Boolean.valueOf(errorMode);
            if (throwError) {
                throw new IOException(errorMessage);
            }
            log.error((Object)errorMessage);
            return null;
        }
        throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
    }

    public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback) throws Throwable {
        return this.acknowledgeCallback(callbackHandler, callback, null);
    }

    public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback, Object response) throws Throwable {
        ArrayList<Callback> callbacks = new ArrayList<Callback>(1);
        callbacks.add(callback);
        ArrayList<Object> responses = null;
        if (response != null) {
            responses = new ArrayList<Object>(1);
            responses.add(response);
        }
        return this.acknowledgeCallbacks(callbackHandler, callbacks, responses);
    }

    public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks) throws Throwable {
        return this.acknowledgeCallbacks(callbackHandler, callbacks, null);
    }

    public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks, List responses) throws Throwable {
        if (callbackHandler == null) {
            throw new Exception("InvokerCallbackHandler parameter must not be null");
        }
        if (callbacks == null) {
            throw new Exception("Callback List parameter must not be null");
        }
        if (responses != null && responses.size() != callbacks.size()) {
            throw new Exception("Callback response list must be (1) null or (2) the same size as callback list");
        }
        if (callbacks.size() == 0) {
            return 0;
        }
        if (this.isConnected()) {
            ArrayList callbackIds = new ArrayList(callbacks.size());
            Iterator idsIterator = callbacks.iterator();
            ArrayList<Object> responseList = null;
            Iterator responseIterator = null;
            if (responses != null) {
                responseList = new ArrayList<Object>(responses.size());
                responseIterator = responses.iterator();
            }
            Callback callback = null;
            Object response = null;
            String listenerId = null;
            for (int i = 0; i < callbacks.size(); ++i) {
                Map returnPayload;
                callback = (Callback)idsIterator.next();
                if (responseIterator != null) {
                    response = responseIterator.next();
                }
                if ((returnPayload = callback.getReturnPayload()) != null) {
                    Object callbackId = returnPayload.get("callbackId");
                    if (callbackId != null) {
                        String nextListenerId;
                        callbackIds.add(callbackId);
                        if (responseIterator != null) {
                            responseList.add(response);
                        }
                        if ((nextListenerId = (String)returnPayload.get(LISTENER_ID_KEY)) == null) {
                            throw new Exception("Cannot acknowledge callbacks: callback " + callbackId + " has null listener id");
                        }
                        if (i == 0) {
                            listenerId = nextListenerId;
                            continue;
                        }
                        if (listenerId.equals(nextListenerId)) continue;
                        throw new Exception("Cannot acknowledge callbacks: all must be from same server side callback handler");
                    }
                    log.error((Object)"Cannot acknowledge callback: callback id is missing from return payload");
                    continue;
                }
                log.error((Object)"Cannot acknowledge callback: return payload is null");
            }
            if (callbackIds.size() == 0) {
                return 0;
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (listenerId == null) {
                throw new Exception("Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler " + "has been registered as listener.");
            }
            metadata.put(LISTENER_ID_KEY, listenerId);
            Object[] params = new Object[]{callbackIds, responseList};
            InternalInvocation invocation = new InternalInvocation("acknowledgeCallback", params);
            this.invoke(invocation, metadata);
            return callbackIds.size();
        }
        throw new Exception("Can not acknowledge Callback due to not being connected to server.");
    }

    public void setMarshaller(Marshaller marshaller) {
        if (this.isConnected()) {
            if (marshaller == null) {
                throw new NullPointerException("Can not set Marshaller with a null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client Marshaller when not connected.");
        }
        this.invoker.setMarshaller(marshaller);
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        if (this.isConnected()) {
            if (unmarshaller == null) {
                throw new NullPointerException("Can not set UnMarshaller to null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client UnMarhshaller when not connected.");
        }
        this.invoker.setUnMarshaller(unmarshaller);
    }

    public Object invoke(InputStream inputStream, Object param) throws Throwable {
        StreamServer streamServer = null;
        streamServer = this.invoker instanceof LocalClientInvoker ? new StreamServer(inputStream, "local") : new StreamServer(inputStream);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public Object invoke(InputStream inputStream, Object param, Connector streamConnector) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream, streamConnector);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public Object invoke(InputStream inputStream, Object param, InvokerLocator streamServerLocator) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream, streamServerLocator);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public long getPingPeriod() {
        if (this.connectionValidator == null) {
            return -1L;
        }
        return this.connectionValidator.getPingPeriod();
    }

    public long getLeasePeriod() {
        if (this.invoker == null) {
            return -1L;
        }
        return this.invoker.getLeasePeriod(this.sessionId);
    }

    public InetAddress getAddressSeenByServer() throws Throwable {
        return (InetAddress)this.invoke("$GET_CLIENT_LOCAL_ADDRESS$");
    }

    public String toString() {
        return "Client[" + System.identityHashCode(this) + ":" + this.sessionId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners() {
        Object object = connectionValidatorLock;
        synchronized (object) {
            log.debug((Object)(this + " entering notifyListeners(): " + this.connectionValidator));
            if (this.connectionValidator != null) {
                ConnectionValidator connectionValidator = this.connectionValidator;
                synchronized (connectionValidator) {
                    if (this.connectionValidator.isStopped()) {
                        if (trace) {
                            log.trace((Object)(this + ": " + this.connectionValidator + " is stopped"));
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)(this + ": " + this.connectionValidator + " is not stopped"));
                        }
                        if (trace) {
                            log.trace((Object)(this + " calling connectionValidator.notifyListeners()"));
                        }
                        this.connectionValidator.notifyListeners(new Exception("Could not connect to server!"));
                        Iterator it = this.connectionListeners.iterator();
                        while (it.hasNext()) {
                            ConnectionListener listener = (ConnectionListener)it.next();
                            this.connectionValidator.removeConnectionListener(this, listener);
                        }
                        if (connectionValidators.remove(this.connectionValidatorKey) != null && trace) {
                            log.trace((Object)(this + ".notifyAndDisconnect() removed from static map: " + this.connectionValidator));
                        }
                    }
                }
                this.connectionValidator = null;
                this.connectionValidatorKey = null;
            }
            log.debug((Object)(this + " leaving notifyListeners()"));
        }
    }

    static Object getConnectionValidatorLock() {
        return connectionValidatorLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(ClientInvoker invoker, ConnectionListener listener, Map metadata) {
        if (invoker != null) {
            invoker.connect();
            try {
                this.setupClientLease(invoker, listener, metadata);
            }
            catch (Throwable throwable) {
                CannotConnectException e = new CannotConnectException("Error setting up client lease upon performing connect.");
                e.initCause(throwable);
                throw e;
            }
            log.debug((Object)(this + " connected to " + this.locator));
            if (this.invokerDestructionDelay > 0) {
                Object object = invokerDestructionTimerLock;
                synchronized (object) {
                    log.debug((Object)(this + " clientCounter: " + ++clientCounter));
                }
            }
        } else {
            throw new RuntimeException("Client invoker is null (may have used void constructor for Client, which should only be used for Externalization.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupClientLease(ClientInvoker invoker, ConnectionListener listener, Map metadata) throws Throwable {
        long leasePeriod = -1L;
        boolean enableLease = false;
        if (invoker != null) {
            if (invoker instanceof LocalClientInvoker) {
                return;
            }
            InvokerLocator locator = invoker.getLocator();
            Map locatorParams = locator.getParameters();
            if (locatorParams != null) {
                String leasePeriodValue;
                String leaseValue = (String)locatorParams.get("leasing");
                if (leaseValue != null && leaseValue.length() > 0) {
                    enableLease = Boolean.valueOf(leaseValue);
                }
                if ((leasePeriodValue = (String)locatorParams.get("lease_period")) != null && leasePeriodValue.length() > 0) {
                    try {
                        leasePeriod = Long.parseLong(leasePeriodValue);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Could not convert client lease period value (" + leasePeriodValue + ") to a number."));
                    }
                }
            }
        } else {
            throw new RuntimeException("Can not set up client lease as client invoker is null.");
        }
        if (this.configuration != null) {
            String leasePeriodValue;
            Object val = this.configuration.get(ENABLE_LEASE);
            if (val != null) {
                if (val instanceof Boolean) {
                    enableLease = (Boolean)val;
                } else if (val instanceof String) {
                    enableLease = Boolean.valueOf((String)val);
                } else {
                    log.warn((Object)("Can not evaluate enableLease value (" + val + ") as a boolean type."));
                }
            }
            if ((leasePeriodValue = (String)this.configuration.get("lease_period")) != null && leasePeriodValue.length() > 0) {
                try {
                    leasePeriod = Long.parseLong(leasePeriodValue);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Could not convert client lease period value (" + leasePeriodValue + ") to a number."));
                }
            }
        }
        if (trace) {
            log.trace((Object)(this + " enableLease: " + enableLease));
        }
        if (enableLease) {
            HashMap<String, Object> temp = new HashMap<String, Object>(this.configuration);
            if (metadata != null) {
                temp.putAll(metadata);
            }
            if (this.useClientConnectionIdentity) {
                temp.put(CLIENT, this);
                temp.put(CONNECTION_LISTENER, listener);
            }
            if (trace) {
                log.trace((Object)(this + " calling MicroRemoteClientInvoker.establishLease()"));
            }
            Object object = connectionValidatorLock;
            synchronized (object) {
                invoker.establishLease(this.sessionId, temp, leasePeriod);
            }
        } else if (listener != null) {
            this.addConnectionListener(listener, metadata);
        }
    }

    private Object invoke(Object param, Map metadata, InvokerLocator callbackServerLocator) throws Throwable {
        if (this.isConnected()) {
            return this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, callbackServerLocator));
        }
        throw new Exception("Can not make remoting client invocation due to not being connected to server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallbackListener(InvokerCallbackHandler callbackhandler, Map metadata, InvokerLocator callbackLocator, Object callbackHandlerObject) throws Throwable {
        if (callbackLocator == null) {
            String listenerId = this.generateListenerId(callbackhandler);
            if (listenerId != null) {
                HashMap<String, String> internalMetadata = new HashMap<String, String>();
                internalMetadata.put(LISTENER_ID_KEY, listenerId);
                if (metadata != null) {
                    internalMetadata.putAll(metadata);
                }
                this.invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
            }
        } else {
            String listenerId = this.invoker.addClientLocator(this.sessionId, callbackhandler, callbackLocator);
            if (listenerId != null) {
                HashMap<String, String> internalMetadata = new HashMap<String, String>();
                internalMetadata.put(LISTENER_ID_KEY, listenerId);
                if (metadata != null) {
                    internalMetadata.putAll(metadata);
                }
                Client client = new Client(callbackLocator, this.subsystem);
                client.setSessionId(this.getSessionId());
                client.connect();
                try {
                    InternalInvocation i = new InternalInvocation("addClientListener", new Object[]{callbackhandler, callbackHandlerObject});
                    client.invoke(i, internalMetadata);
                }
                finally {
                    client.disconnect();
                }
                this.invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
            }
        }
    }

    private String generateListenerId(InvokerCallbackHandler callbackhandler) {
        String listenerId = null;
        Object obj = this.listeners.get(callbackhandler);
        if (obj == null) {
            listenerId = new GUID().toString();
            this.listeners.put(callbackhandler, listenerId);
        }
        return listenerId;
    }

    private void processParameters() {
        Object param;
        HashMap params = new HashMap();
        if (this.configuration != null) {
            params.putAll(this.configuration);
        }
        if (this.locator.getParameters() != null) {
            params.putAll(this.locator.getParameters());
        }
        if ((param = params.get(INVOKER_DESTRUCTION_DELAY)) instanceof String) {
            try {
                this.invokerDestructionDelay = Integer.parseInt((String)param);
                log.debug((Object)(this + " setting invokerDestructionDelay to " + this.invokerDestructionDelay));
            }
            catch (NumberFormatException e) {
                log.error((Object)("invokerDestructionDelay parameter has invalid format: " + param));
            }
        } else if (param != null) {
            log.error((Object)("invokerDestructionDelay parameter must be a string in integer format: " + param));
        }
        if ((param = this.configuration.get("useClientConnectionIdentity")) instanceof String) {
            this.useClientConnectionIdentity = Boolean.valueOf((String)param);
        } else if (param != null) {
            log.warn((Object)("value of useClientConnectionIdentity must be a String: " + param));
        } else if (this.locator.getParameters() != null && (param = this.locator.getParameters().get("useClientConnectionIdentity")) != null) {
            this.useClientConnectionIdentity = Boolean.valueOf((String)param);
            this.configuration.put("useClientConnectionIdentity", param);
        }
        param = this.configuration.get("useServerConnectionIdentity");
        if (param instanceof String) {
            this.useServerConnectionIdentity = Boolean.valueOf((String)param);
        } else if (param != null) {
            log.warn((Object)("value of useServerConnectionIdentity must be a String: " + param));
        } else if (this.locator.getParameters() != null && (param = this.locator.getParameters().get("useServerConnectionIdentity")) != null) {
            this.useServerConnectionIdentity = Boolean.valueOf((String)param);
            this.configuration.put("useServerConnectionIdentity", param);
        }
        PortUtil.updateRange(params);
    }

    private void configureCallbackServerSocketFactory(Map map) throws Exception {
        Boolean supportsSSL = null;
        try {
            supportsSSL = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Boolean(InvokerRegistry.isSSLSupported(Client.this.locator.getProtocol()));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        if (supportsSSL.booleanValue() && !map.containsKey("customServerSocketFactory") && !map.containsKey("serverSocketFactory") && !map.containsKey("org.jboss.remoting.serversocket.useClientMode")) {
            map.put("org.jboss.remoting.serversocket.useClientMode", "true");
        }
    }

    static {
        invokerDestructionTimerLock = new Object();
        try {
            LOCAL_HOST = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)(Client.class.getName() + " unable to get local host address"), e.getCause());
            throw new ExceptionInInitializerError(e.getCause());
        }
        catch (SecurityException e) {
            log.debug((Object)(Client.class.getName() + " unable to get local host address"), (Throwable)e);
            throw e;
        }
    }

    static class ConnectionValidatorKey {
        private ClientInvoker invoker;
        private Map metadata;

        ConnectionValidatorKey(ClientInvoker invoker, Map metadata) {
            this.invoker = invoker;
            this.metadata = metadata;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ConnectionValidatorKey)) {
                return false;
            }
            ConnectionValidatorKey holder = (ConnectionValidatorKey)o;
            boolean metadataEquals = this.metadata == null && holder.metadata == null || ((Object)this.metadata).equals(holder.metadata);
            return this.invoker == holder.invoker && metadataEquals;
        }

        public int hashCode() {
            return this.invoker.hashCode() * ((Object)this.metadata).hashCode();
        }
    }

    static class InvokerDestructionTimerTask
    extends TimerTask {
        private ClientInvoker invoker;
        private Map config;

        public InvokerDestructionTimerTask(ClientInvoker invoker, Map config) {
            this.invoker = invoker;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug((Object)(this + " calling InvokerRegistry.destroyClientInvoker() for " + this.invoker));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    InvokerRegistry.destroyClientInvoker(InvokerDestructionTimerTask.this.invoker.getLocator(), InvokerDestructionTimerTask.this.config);
                    return null;
                }
            });
            Object object = invokerDestructionTimerLock;
            synchronized (object) {
                if (--clientCounter == 0) {
                    invokerDestructionTimer.cancel();
                    invokerDestructionTimer = null;
                    log.debug((Object)(this + " stopped invokerDestructionTimer"));
                }
                log.debug((Object)(this + " clientCounter: " + clientCounter));
            }
            log.debug((Object)(this + "done"));
        }
    }
}

