/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.metadata.internal.AbstractPackageAttribute;
import org.jboss.osgi.metadata.internal.AbstractParameter;
import org.jboss.osgi.metadata.internal.AbstractParameterizedAttribute;
import org.jboss.osgi.metadata.internal.ValueCreator;
import org.jboss.osgi.metadata.internal.ValueCreatorUtil;
import org.jboss.osgi.metadata.spi.ElementParser;
import org.jboss.osgi.metadata.spi.NotNullException;

public class ManifestParser {
    public static void parsePackages(String header, List<PackageAttribute> list) {
        ManifestParser.parse(header, list, true, false);
    }

    public static void parseParameters(String header, List<ParameterizedAttribute> list) {
        ManifestParser.parse(header, list, false, false);
    }

    public static void parsePaths(String header, List<ParameterizedAttribute> list) {
        ManifestParser.parse(header, list, false, false);
    }

    public static void parse(String header, List list, boolean packages, boolean allowDuplicateAttributes) {
        NotNullException.assertValue(header, "header");
        if (header.length() == 0) {
            throw new IllegalArgumentException("Invalid null header");
        }
        List<String> clauses = ElementParser.parseDelimitedString(header, ',');
        for (String clause : clauses) {
            List<String> pieces = ElementParser.parseDelimitedString(clause, ';');
            ArrayList<String> paths = new ArrayList<String>();
            for (String piece : pieces) {
                if (piece.indexOf(61) >= 0) break;
                paths.add(ManifestParser.unquote(piece));
            }
            if (paths.isEmpty()) {
                throw new IllegalArgumentException("No paths for clause: " + clause);
            }
            LinkedHashMap<String, AbstractParameter> directives = null;
            LinkedHashMap<String, Parameter> attributes = null;
            for (int i = paths.size(); i < pieces.size(); ++i) {
                String value;
                String name;
                String piece = pieces.get(i);
                int seperator = piece.indexOf(":=");
                if (seperator >= 0) {
                    name = piece.substring(0, seperator);
                    value = piece.substring(seperator + 2);
                    if (directives == null) {
                        directives = new LinkedHashMap<String, AbstractParameter>();
                    }
                    if (directives.containsKey(name = ManifestParser.unquote(name.trim()))) {
                        throw new IllegalArgumentException("Duplicate directive: " + name);
                    }
                    value = ManifestParser.unquote(value.trim());
                    directives.put(name, new AbstractParameter(ValueCreatorUtil.STRING_VC, value));
                    continue;
                }
                seperator = piece.indexOf("=");
                if (seperator >= 0) {
                    Parameter attribute;
                    name = piece.substring(0, seperator);
                    value = piece.substring(seperator + 1);
                    ValueCreator<String> vc = ValueCreatorUtil.STRING_VC;
                    if (attributes == null) {
                        attributes = new LinkedHashMap<String, Parameter>();
                    }
                    if ((seperator = (name = ManifestParser.unquote(name.trim())).indexOf(":")) >= 0) {
                        String type = name.substring(seperator + 1).trim();
                        if (type.startsWith("List")) {
                            int index = type.indexOf(60);
                            String subtype = index > 0 ? type.substring(index + 1, type.indexOf(62)) : "String";
                            type = "List<" + subtype.trim() + ">";
                        }
                        vc = ValueCreatorUtil.forType(type);
                        name = name.substring(0, seperator).trim();
                    }
                    if ((attribute = (Parameter)attributes.get(name)) != null) {
                        if (!allowDuplicateAttributes) {
                            throw new IllegalArgumentException("Duplicate attribute: " + name);
                        }
                    } else {
                        attribute = new AbstractParameter(vc);
                        attributes.put(name, attribute);
                    }
                    value = ManifestParser.unquote(value.trim());
                    attribute.addValue(value);
                    continue;
                }
                throw new IllegalArgumentException("Path [" + piece + "] should appear before attributes and directives in clause: " + clause);
            }
            for (String path : paths) {
                AbstractParameterizedAttribute metadata = null;
                metadata = packages ? new AbstractPackageAttribute(path, attributes, directives) : new AbstractParameterizedAttribute(path, attributes, directives);
                list.add(metadata);
            }
        }
    }

    private static String unquote(String string) {
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

