/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTestHelper {
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static String testResourcesDir;
    private static String testArchiveDir;

    public OSGiTestHelper() {
        testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY, "target/test-classes");
        testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY, "target/test-libs");
    }

    public URL getResourceURL(String resource) {
        URL resURL = null;
        try {
            File resourceFile = this.getResourceFile(resource);
            resURL = resourceFile.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resURL;
    }

    public File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(testResourcesDir + "/" + resource);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testResourcesDir + "/" + resource + "'");
    }

    public URL getTestArchiveURL(String archive) {
        try {
            URL archiveURL = new URL(archive);
            return archiveURL;
        }
        catch (MalformedURLException ex) {
            try {
                File file = this.getTestArchiveFile(archive);
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new IllegalStateException(ex2);
            }
        }
    }

    public String getTestArchivePath(String archive) {
        File archiveFile = this.getTestArchiveFile(archive);
        return archiveFile.getAbsolutePath();
    }

    public File getTestArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(testArchiveDir + "/" + archive);
        if (file.exists()) {
            return file;
        }
        throw new IllegalArgumentException("Cannot obtain '" + testArchiveDir + "/" + archive + "'.");
    }

    public InitialContext getInitialContext() throws NamingException {
        String port = System.getProperty("jndi.server.port", "1099");
        Integer jndiPort = new Integer(port);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        env.put("java.naming.provider.url", "jnp://" + this.getServerHost() + ":" + jndiPort);
        return new InitialContext(env);
    }

    public String getServerHost() {
        String bindAddress = System.getProperty("jboss.bind.address", "localhost");
        return bindAddress;
    }

    public String getTargetContainer() {
        String targetContainer = System.getProperty("target.container");
        return targetContainer;
    }

    public String getFrameworkName() {
        String framework = System.getProperty("framework");
        if (framework == null || framework.length() == 0 || framework.equals("${framework}")) {
            framework = "jbossmc";
        }
        return framework;
    }

    public Archive<?> assembleArchive(String name, String resource, Class<?> ... packages) throws Exception {
        return this.assembleArchive(name, new String[]{resource}, packages);
    }

    public Archive<?> assembleArchive(String name, String[] resources, Class<?> ... packages) throws IOException {
        URL url;
        JavaArchive archive = (JavaArchive)Archives.create((String)(name + ".jar"), JavaArchive.class);
        if (resources != null) {
            for (String res : resources) {
                url = this.getClass().getResource(res);
                if (url == null) {
                    throw new IllegalArgumentException("Cannot load resource: " + (String)res);
                }
                VirtualFile file = AbstractVFS.getRoot((URL)url);
                if (file.isDirectory()) {
                    this.addResources(archive, file, file);
                    continue;
                }
                this.addResource(archive, res, file);
            }
        }
        if (packages != null) {
            for (Class<?> clazz : packages) {
                url = clazz.getResource("/");
                VirtualFile base = AbstractVFS.getRoot((URL)url);
                String path = clazz.getName().replace('.', '/');
                path = path.substring(0, path.lastIndexOf("/"));
                VirtualFile classes = base.getChild(path);
                this.addResources(archive, base, classes);
            }
        }
        return archive;
    }

    public static VirtualFile toVirtualFile(Archive archive) throws IOException, MalformedURLException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        File target = File.createTempFile("osgi-bundle_", ".jar");
        exporter.exportZip(target, true);
        target.deleteOnExit();
        return AbstractVFS.getRoot((URL)target.toURI().toURL());
    }

    private void addResources(JavaArchive archive, VirtualFile basedir, VirtualFile resdir) throws IOException {
        String basepath = basedir.getPathName();
        for (VirtualFile child : resdir.getChildrenRecursively()) {
            if (child.isDirectory()) continue;
            String path = child.getPathName();
            path = path.substring(basepath.length());
            this.addResource(archive, path, child);
        }
    }

    private void addResource(JavaArchive archive, String path, final VirtualFile file) {
        Asset asset = new Asset(){

            public InputStream openStream() {
                try {
                    return file.openStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot open stream for: " + file, ex);
                }
            }
        };
        archive.add(asset, path);
    }

    public void assertBundleState(int expState, int wasState) {
        String expstr = ConstantsHelper.bundleState(expState);
        String wasstr = ConstantsHelper.bundleState(wasState);
        Assert.assertEquals((String)("Bundle " + expstr), (Object)expstr, (Object)wasstr);
    }

    public Class<?> assertLoadClass(Bundle bundle, String className) {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            String message = bundle.getSymbolicName() + " loads " + className;
            Assert.fail((String)("Unexpected ClassNotFoundException for: " + message));
            return null;
        }
    }

    public void assertLoadClassFail(Bundle bundle, String className) {
        try {
            Class clazz = bundle.loadClass(className);
            String message = bundle.getSymbolicName() + " loads " + className;
            Assert.fail((String)("ClassNotFoundException expected for: " + message + "\nLoaded from " + clazz.getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

