/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices.base.processors;

public abstract class Callback {
    private boolean triggered;
    private boolean failed;

    public final synchronized boolean hasTriggered() {
        return this.triggered;
    }

    public final synchronized void setTriggered() {
        this.triggered = true;
        this.notifyAll();
    }

    public final synchronized boolean hasFailed() {
        return this.failed;
    }

    public final synchronized void setFailed() {
        this.failed = true;
        this.notifyAll();
    }

    public final void waitUntilTriggered() {
        this.waitUntilTriggered(0L);
    }

    public final synchronized void waitUntilTriggered(long delay) {
        long endTime = delay <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + delay;
        long now = System.currentTimeMillis();
        while (endTime > now && !this.triggered && !this.failed) {
            try {
                this.wait(endTime - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
    }
}

