/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;

public final class ModuleSpec {
    private final ModuleIdentifier moduleIdentifier;
    private final String mainClass;
    private final AssertionSetting assertionSetting;
    private final ResourceLoaderSpec[] resourceLoaders;
    private final DependencySpec[] dependencies;
    private final LocalLoader fallbackLoader;
    private final ModuleClassLoaderFactory moduleClassLoaderFactory;

    private ModuleSpec(ModuleIdentifier moduleIdentifier, String mainClass, AssertionSetting assertionSetting, ResourceLoaderSpec[] resourceLoaders, DependencySpec[] dependencies, LocalLoader fallbackLoader, ModuleClassLoaderFactory moduleClassLoaderFactory) {
        this.moduleIdentifier = moduleIdentifier;
        this.mainClass = mainClass;
        this.assertionSetting = assertionSetting;
        this.resourceLoaders = resourceLoaders;
        this.dependencies = dependencies;
        this.fallbackLoader = fallbackLoader;
        this.moduleClassLoaderFactory = moduleClassLoaderFactory;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    String getMainClass() {
        return this.mainClass;
    }

    AssertionSetting getAssertionSetting() {
        return this.assertionSetting;
    }

    ResourceLoaderSpec[] getResourceLoaders() {
        return this.resourceLoaders;
    }

    DependencySpec[] getDependencies() {
        return this.dependencies;
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    ModuleClassLoaderFactory getModuleClassLoaderFactory() {
        return this.moduleClassLoaderFactory;
    }

    public static Builder build(final ModuleIdentifier moduleIdentifier) {
        return new Builder(){
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>(0);
            private final List<DependencySpec> dependencies = new ArrayList<DependencySpec>();
            private LocalLoader fallbackLoader;
            private ModuleClassLoaderFactory moduleClassLoaderFactory;

            @Override
            public Builder setFallbackLoader(LocalLoader fallbackLoader) {
                this.fallbackLoader = fallbackLoader;
                return this;
            }

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting;
                return this;
            }

            @Override
            public Builder addDependency(DependencySpec dependencySpec) {
                this.dependencies.add(dependencySpec);
                return null;
            }

            @Override
            public Builder addResourceRoot(ResourceLoaderSpec resourceLoader) {
                this.resourceLoaders.add(resourceLoader);
                return this;
            }

            @Override
            public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory moduleClassLoaderFactory) {
                this.moduleClassLoaderFactory = moduleClassLoaderFactory;
                return this;
            }

            @Override
            public ModuleSpec create() {
                return new ModuleSpec(moduleIdentifier, this.mainClass, this.assertionSetting, this.resourceLoaders.toArray(new ResourceLoaderSpec[this.resourceLoaders.size()]), this.dependencies.toArray(new DependencySpec[this.dependencies.size()]), this.fallbackLoader, this.moduleClassLoaderFactory);
            }

            @Override
            public ModuleIdentifier getIdentifier() {
                return moduleIdentifier;
            }
        };
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addDependency(DependencySpec var1);

        public Builder addResourceRoot(ResourceLoaderSpec var1);

        public ModuleSpec create();

        public ModuleIdentifier getIdentifier();

        public Builder setFallbackLoader(LocalLoader var1);

        public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory var1);
    }
}

