/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Pattern;

public final class ModuleIdentifier
implements Serializable {
    private static final long serialVersionUID = 118533026624827995L;
    private static Pattern MODULE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_](?:[-a-zA-Z0-9_]*[a-zA-Z0-9_])?(?:\\.[a-zA-Z0-9_](?:[-a-zA-Z0-9_]*[a-zA-Z0-9_])?)*");
    private static Pattern SLOT_PATTERN = Pattern.compile("[-a-zA-Z0-9_+*.]+");
    private static String DEFAULT_SLOT = "main";
    private final String name;
    private final String slot;
    private final transient int hashCode;
    private static final Field hashField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field field;
            try {
                field = ModuleIdentifier.class.getDeclaredField("hashCode");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            return field;
        }
    });
    public static final ModuleIdentifier SYSTEM = new ModuleIdentifier("system", DEFAULT_SLOT);

    private ModuleIdentifier(String name, String slot) {
        this.name = name;
        this.slot = slot;
        this.hashCode = ModuleIdentifier.calculateHashCode(name, slot);
    }

    private static int calculateHashCode(String name, String slot) {
        int h = 17;
        h = 37 * h + name.hashCode();
        h = 37 * h + slot.hashCode();
        return h;
    }

    public String getName() {
        return this.name;
    }

    public String getSlot() {
        return this.slot;
    }

    public boolean equals(Object other) {
        return other instanceof ModuleIdentifier && this.equals((ModuleIdentifier)other);
    }

    public boolean equals(ModuleIdentifier other) {
        return this == other || other != null && this.name.equals(other.name) && this.slot.equals(other.slot);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name + ":" + this.slot;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashField.setInt(this, ModuleIdentifier.calculateHashCode(this.name, this.slot));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static ModuleIdentifier fromString(String moduleSpec) throws IllegalArgumentException {
        String slot;
        String name;
        if (moduleSpec == null) {
            throw new IllegalArgumentException("Module specification is null");
        }
        if (moduleSpec.length() == 0) {
            throw new IllegalArgumentException("Empty module specification");
        }
        int c1 = moduleSpec.lastIndexOf(58);
        if (c1 != -1) {
            name = moduleSpec.substring(0, c1);
            slot = moduleSpec.substring(c1 + 1);
            if (!SLOT_PATTERN.matcher(slot).matches()) {
                throw new IllegalArgumentException("Slot has invalid characters or is empty");
            }
        } else {
            name = moduleSpec;
            slot = DEFAULT_SLOT;
        }
        if (!MODULE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Module name contains invalid characters, or empty segments");
        }
        return new ModuleIdentifier(name, slot);
    }

    public static ModuleIdentifier create(String name, String slot) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        if (slot == null) {
            slot = DEFAULT_SLOT;
        }
        return new ModuleIdentifier(name, slot);
    }

    public static ModuleIdentifier create(String name) {
        return ModuleIdentifier.create(name, null);
    }
}

