/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.server.management.impl;

import javax.jms.JMSException;
import org.jboss.messaging.core.client.management.impl.ManagementHelper;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.jms.client.JBossMessage;

public class JMSManagementHelper {
    private static Message getCoreMessage(javax.jms.Message jmsMessage) {
        if (!(jmsMessage instanceof JBossMessage)) {
            throw new IllegalArgumentException("Cannot send a non JBoss message as a management message " + jmsMessage.getClass().getName());
        }
        return ((JBossMessage)jmsMessage).getCoreMessage();
    }

    public static void putAttribute(javax.jms.Message message, String resourceName, String attribute) throws JMSException {
        ManagementHelper.putAttribute((Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)attribute);
    }

    public static void putOperationInvocation(javax.jms.Message message, String resourceName, String operationName) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    private static JMSException convertFromException(Exception e) {
        JMSException jmse = new JMSException(e.getMessage());
        jmse.initCause((Throwable)e);
        return jmse;
    }

    public static void putOperationInvocation(javax.jms.Message message, String resourceName, String operationName, Object ... parameters) throws JMSException {
        try {
            ManagementHelper.putOperationInvocation((Message)JMSManagementHelper.getCoreMessage(message), (String)resourceName, (String)operationName, (Object[])parameters);
        }
        catch (Exception e) {
            throw JMSManagementHelper.convertFromException(e);
        }
    }

    public static boolean isOperationResult(javax.jms.Message message) throws JMSException {
        return ManagementHelper.isOperationResult((Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean isAttributesResult(javax.jms.Message message) throws JMSException {
        return ManagementHelper.isAttributesResult((Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static boolean hasOperationSucceeded(javax.jms.Message message) throws JMSException {
        return ManagementHelper.hasOperationSucceeded((Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object[] getResults(javax.jms.Message message) throws Exception {
        return ManagementHelper.getResults((Message)JMSManagementHelper.getCoreMessage(message));
    }

    public static Object getResult(javax.jms.Message message) throws Exception {
        return ManagementHelper.getResult((Message)JMSManagementHelper.getCoreMessage(message));
    }
}

