/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.server.management;

import org.jboss.messaging.utils.json.JSONArray;
import org.jboss.messaging.utils.json.JSONObject;

public class SubscriptionInfo {
    private final String queueName;
    private final String clientID;
    private final String name;
    private final boolean durable;
    private final String selector;
    private final int messageCount;

    public static SubscriptionInfo[] from(String jsonString) throws Exception {
        JSONArray array = new JSONArray(jsonString);
        SubscriptionInfo[] infos = new SubscriptionInfo[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            SubscriptionInfo info;
            JSONObject sub = array.getJSONObject(i);
            infos[i] = info = new SubscriptionInfo(sub.getString("queueName"), sub.optString("clientID", null), sub.optString("name", null), sub.getBoolean("durable"), sub.optString("selector", null), sub.getInt("messageCount"));
        }
        return infos;
    }

    private SubscriptionInfo(String queueName, String clientID, String name, boolean durable, String selector, int messageCount) {
        this.queueName = queueName;
        this.clientID = clientID;
        this.name = name;
        this.durable = durable;
        this.selector = selector;
        this.messageCount = messageCount;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getSelector() {
        return this.selector;
    }

    public int getMessageCount() {
        return this.messageCount;
    }
}

