/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.server.management;

import java.util.Map;
import org.jboss.messaging.core.management.Operation;
import org.jboss.messaging.core.management.Parameter;
import org.jboss.messaging.jms.server.management.DestinationControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JMSQueueControl
extends DestinationControl {
    @Override
    public String getName();

    public String getExpiryAddress();

    public void setExpiryAddress(@Parameter(name="expiryAddress", desc="Expiry address of the queue") String var1) throws Exception;

    public String getDeadLetterAddress();

    public void setDeadLetterAddress(@Parameter(name="deadLetterAddress", desc="Dead-letter address of the queue") String var1) throws Exception;

    public int getMessagesAdded();

    @Override
    public boolean isTemporary();

    public boolean isDurable();

    @Override
    public int getMessageCount();

    public long getScheduledCount();

    public int getConsumerCount();

    public int getDeliveringCount();

    @Operation(desc="List all messages in the queue which matches the filter", impact=0)
    public Map<String, Object>[] listMessages(@Parameter(name="filter", desc="A JMS Message filter") String var1) throws Exception;

    @Operation(desc="List all messages in the queue which matches the filter and return them using JSON", impact=0)
    public String listMessagesAsJSON(@Parameter(name="filter", desc="A JMS Message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Returns the number of the messages in the queue matching the given filter", impact=0)
    public int countMessages(@Parameter(name="filter", desc="A JMS message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Remove the message corresponding to the given messageID", impact=1)
    public boolean removeMessage(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Override
    @Operation(desc="Remove the messages corresponding to the given filter (and returns the number of removed messages)", impact=1)
    public int removeMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Expire the messages corresponding to the given filter (and returns the number of expired messages)", impact=1)
    public int expireMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1) throws Exception;

    @Operation(desc="Expire the message corresponding to the given messageID", impact=1)
    public boolean expireMessage(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Operation(desc="Send the message corresponding to the given messageID to the queue's Dead Letter Queue", impact=1)
    public boolean sendMessageToDeadLetterAddress(@Parameter(name="messageID", desc="A message ID") String var1) throws Exception;

    @Operation(desc="Change the priority of the message corresponding to the given messageID", impact=1)
    public boolean changeMessagePriority(@Parameter(name="messageID", desc="A message ID") String var1, @Parameter(name="newPriority", desc="the new priority (between 0 and 9)") int var2) throws Exception;

    @Operation(desc="Move the message corresponding to the given messageID to another queue", impact=1)
    public boolean moveMessage(@Parameter(name="messageID", desc="A message ID") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the message to") String var2) throws Exception;

    @Operation(desc="Move the messages corresponding to the given filter (and returns the number of moved messages)", impact=1)
    public int moveMessages(@Parameter(name="filter", desc="A message filter (can be empty)") String var1, @Parameter(name="otherQueueName", desc="The name of the queue to move the messages to") String var2) throws Exception;

    @Operation(desc="List the message counters", impact=0)
    public String listMessageCounter() throws Exception;

    @Operation(desc="List the message counters as HTML", impact=0)
    public String listMessageCounterAsHTML() throws Exception;

    @Operation(desc="List the message counters history", impact=0)
    public String listMessageCounterHistory() throws Exception;

    @Operation(desc="List the message counters history as HTML", impact=0)
    public String listMessageCounterHistoryAsHTML() throws Exception;
}

