/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.MessageHandler;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.jms.client.JBossSession;

public class JMSMessageListenerWrapper
implements MessageHandler {
    private static final Logger log = Logger.getLogger(JMSMessageListenerWrapper.class);
    private final JBossSession session;
    private final MessageListener listener;
    private final ClientConsumer consumer;
    private final boolean transactedOrClientAck;

    public JMSMessageListenerWrapper(JBossSession session, ClientConsumer consumer, MessageListener listener, int ackMode) {
        this.session = session;
        this.consumer = consumer;
        this.listener = listener;
        this.transactedOrClientAck = ackMode == 0 || ackMode == 2;
    }

    public void onMessage(ClientMessage message) {
        block13: {
            JBossMessage jbm = JBossMessage.createMessage(message, this.session.getCoreSession());
            try {
                jbm.doBeforeReceive();
            }
            catch (Exception e) {
                log.error((Object)"Failed to prepare message for receipt", (Throwable)e);
                return;
            }
            if (this.transactedOrClientAck) {
                try {
                    message.acknowledge();
                }
                catch (MessagingException e) {
                    log.error((Object)"Failed to process message", (Throwable)e);
                }
            }
            try {
                this.listener.onMessage((Message)jbm);
            }
            catch (RuntimeException e) {
                log.warn((Object)"Unhandled exception thrown from onMessage", (Throwable)e);
                if (this.transactedOrClientAck) break block13;
                try {
                    this.session.getCoreSession().rollback(true);
                    this.session.setRecoverCalled(true);
                }
                catch (Exception e2) {
                    log.error((Object)"Failed to recover session", (Throwable)e2);
                }
            }
        }
        if (!this.session.isRecoverCalled()) {
            try {
                if (!this.consumer.isClosed() && !this.transactedOrClientAck) {
                    message.acknowledge();
                }
            }
            catch (MessagingException e) {
                log.error((Object)"Failed to process message", (Throwable)e);
            }
        }
        this.session.setRecoverCalled(false);
    }
}

