/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.client.JBossMessage;

public class JBossTextMessage
extends JBossMessage
implements TextMessage {
    public static final byte TYPE = 3;
    public static final Logger log = Logger.getLogger(JBossTextMessage.class);
    private String text;

    public JBossTextMessage() {
        super((byte)3);
    }

    public JBossTextMessage(ClientSession session) {
        super((byte)3, session);
    }

    public JBossTextMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public JBossTextMessage(TextMessage foreign, ClientSession session) throws JMSException {
        super((Message)foreign, (byte)3, session);
        this.text = foreign.getText();
    }

    public byte getType() {
        return 3;
    }

    public void setText(String text) throws JMSException {
        this.checkWrite();
        this.text = text;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    public void doBeforeSend() throws Exception {
        this.getBody().clear();
        this.getBody().writeNullableString(this.text);
        super.doBeforeSend();
    }

    public void doBeforeReceive() throws Exception {
        super.doBeforeReceive();
        this.text = this.getBody().readNullableString();
    }
}

