/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientProducer;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.filter.impl.FilterImpl;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.impl.wireformat.SessionBindingQueryResponseMessage;
import org.jboss.messaging.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.jms.JBossQueue;
import org.jboss.messaging.jms.JBossTemporaryQueue;
import org.jboss.messaging.jms.JBossTemporaryTopic;
import org.jboss.messaging.jms.JBossTopic;
import org.jboss.messaging.jms.client.JBossBytesMessage;
import org.jboss.messaging.jms.client.JBossConnection;
import org.jboss.messaging.jms.client.JBossMapMessage;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.jms.client.JBossMessageConsumer;
import org.jboss.messaging.jms.client.JBossMessageProducer;
import org.jboss.messaging.jms.client.JBossObjectMessage;
import org.jboss.messaging.jms.client.JBossQueueBrowser;
import org.jboss.messaging.jms.client.JBossStreamMessage;
import org.jboss.messaging.jms.client.JBossTextMessage;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.jms.client.SelectorTranslator;
import org.jboss.messaging.utils.SimpleString;

public class JBossSession
implements Session,
XASession,
QueueSession,
XAQueueSession,
TopicSession,
XATopicSession {
    public static final int TYPE_GENERIC_SESSION = 0;
    public static final int TYPE_QUEUE_SESSION = 1;
    public static final int TYPE_TOPIC_SESSION = 2;
    public static final int PRE_ACKNOWLEDGE = 100;
    private static SimpleString REJECTING_FILTER = new SimpleString("_JBMX=-1");
    private static final Logger log = Logger.getLogger(JBossSession.class);
    private final JBossConnection connection;
    private final ClientSession session;
    private final int sessionType;
    private final int ackMode;
    private final boolean transacted;
    private final boolean xa;
    private boolean recoverCalled;
    private final Set<JBossMessageConsumer> consumers = new HashSet<JBossMessageConsumer>();

    public JBossSession(JBossConnection connection, boolean transacted, boolean xa, int ackMode, ClientSession session, int sessionType) {
        this.connection = connection;
        this.ackMode = ackMode;
        this.session = session;
        this.sessionType = sessionType;
        this.transacted = transacted;
        this.xa = xa;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new JBossBytesMessage(this.session);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new JBossMapMessage(this.session);
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new JBossMessage(this.session);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new JBossObjectMessage(this.session);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        JBossObjectMessage jbm = new JBossObjectMessage(this.session);
        jbm.setObject(object);
        return jbm;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new JBossStreamMessage(this.session);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new JBossTextMessage(this.session);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        JBossTextMessage jbm = new JBossTextMessage(this.session);
        jbm.setText(text);
        return jbm;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.ackMode;
    }

    public void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot commit a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call commit on an XA session");
        }
        try {
            this.session.commit();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot rollback a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call rollback on an XA session");
        }
        try {
            this.session.rollback();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void close() throws JMSException {
        try {
            for (JBossMessageConsumer cons : new HashSet<JBossMessageConsumer>(this.consumers)) {
                cons.close();
            }
            this.session.close();
            this.connection.removeSession(this);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Cannot recover a transacted session");
        }
        try {
            this.session.rollback();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
        this.recoverCalled = true;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
    }

    public void run() {
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBoss Destination:" + destination);
        }
        try {
            JBossDestination jbd = (JBossDestination)destination;
            ClientProducer producer = this.session.createProducer(jbd == null ? null : jbd.getSimpleAddress());
            return new JBossMessageProducer(this.connection, producer, jbd, this.session);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(destination instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBossDestination:" + destination);
        }
        JBossDestination jbdest = (JBossDestination)destination;
        JBossMessageConsumer consumer = this.createConsumer(jbdest, null, messageSelector, noLocal);
        return consumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        JBossQueue queue = new JBossQueue(queueName);
        try {
            SessionQueueQueryResponseMessage response = this.session.queueQuery(queue.getSimpleAddress());
            if (!response.isExists()) {
                throw new JMSException("There is no queue with name " + queueName);
            }
            return queue;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        JBossTopic topic = new JBossTopic(topicName);
        try {
            SessionBindingQueryResponseMessage response = this.session.bindingQuery(topic.getSimpleAddress());
            if (!response.isExists()) {
                throw new JMSException("There is no topic with name " + topicName);
            }
            return topic;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
        }
        if (!(topic instanceof JBossTopic)) {
            throw new InvalidDestinationException("Not a JBossTopic:" + topic);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        JBossDestination jbdest = (JBossDestination)topic;
        return this.createConsumer(jbdest, name, messageSelector, noLocal);
    }

    private JBossMessageConsumer createConsumer(JBossDestination dest, String subscriptionName, String selectorString, boolean noLocal) throws JMSException {
        try {
            ClientConsumer consumer;
            SessionQueueQueryResponseMessage response;
            String string = selectorString = "".equals(selectorString) ? null : selectorString;
            if (noLocal) {
                this.connection.setHasNoLocal();
                String filter = JBossConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getUID() + "'";
                selectorString = selectorString != null ? selectorString + " AND " + filter : filter;
            }
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToJBMFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            if (dest instanceof Queue) {
                response = this.session.queueQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    throw new InvalidDestinationException("Queue " + dest.getName() + " does not exist");
                }
                consumer = this.session.createConsumer(dest.getSimpleAddress(), coreFilterString, false);
            } else {
                response = this.session.bindingQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    throw new InvalidDestinationException("Topic " + dest.getName() + " does not exist");
                }
                if (subscriptionName == null) {
                    SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createTemporaryQueue(dest.getSimpleAddress(), queueName, coreFilterString);
                    consumer = this.session.createConsumer(queueName, null, false);
                    autoDeleteQueueName = queueName;
                } else {
                    if (this.connection.getClientID() == null) {
                        throw new InvalidClientIDException("Cannot create durable subscription - client ID has not been set");
                    }
                    if (dest.isTemporary()) {
                        throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                    }
                    SimpleString queueName = new SimpleString(JBossTopic.createQueueNameForDurableSubscription(this.connection.getClientID(), subscriptionName));
                    SessionQueueQueryResponseMessage subResponse = this.session.queueQuery(queueName);
                    if (!subResponse.isExists()) {
                        this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                    } else {
                        boolean topicChanged;
                        if (subResponse.getConsumerCount() > 0) {
                            throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                        }
                        SimpleString oldFilterString = subResponse.getFilterString();
                        boolean selectorChanged = coreFilterString == null && oldFilterString != null || oldFilterString == null && coreFilterString != null || oldFilterString != null && coreFilterString != null && !oldFilterString.equals((Object)coreFilterString);
                        SimpleString oldTopicName = subResponse.getAddress();
                        boolean bl = topicChanged = !oldTopicName.equals((Object)dest.getSimpleAddress());
                        if (selectorChanged || topicChanged) {
                            this.session.deleteQueue(queueName);
                            this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                        }
                    }
                    consumer = this.session.createConsumer(queueName, null, false);
                }
            }
            JBossMessageConsumer jbc = new JBossMessageConsumer(this, consumer, noLocal, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String filterString) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a browser on a TopicSession");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot create a browser with a null queue");
        }
        if (!(queue instanceof JBossQueue)) {
            throw new InvalidDestinationException("Not a JBossQueue:" + queue);
        }
        if ("".equals(filterString)) {
            filterString = null;
        }
        try {
            FilterImpl.createFilter((String)filterString);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
        JBossQueue jbq = (JBossQueue)queue;
        try {
            SessionBindingQueryResponseMessage message = this.session.bindingQuery(new SimpleString(jbq.getAddress()));
            if (!message.isExists()) {
                throw new InvalidDestinationException(jbq.getAddress() + " does not exist");
            }
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
        return new JBossQueueBrowser(jbq, filterString, this.session);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        String queueName = UUID.randomUUID().toString();
        try {
            JBossTemporaryQueue queue = new JBossTemporaryQueue(this, queueName);
            SimpleString simpleAddress = queue.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress);
            this.connection.addTemporaryQueue(simpleAddress);
            return queue;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        String topicName = UUID.randomUUID().toString();
        try {
            JBossTemporaryTopic topic = new JBossTemporaryTopic(this, topicName);
            SimpleString simpleAddress = topic.getSimpleAddress();
            this.session.createQueue(simpleAddress, simpleAddress, REJECTING_FILTER, false);
            this.connection.addTemporaryQueue(simpleAddress);
            return topic;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        SimpleString queueName = new SimpleString(JBossTopic.createQueueNameForDurableSubscription(this.connection.getClientID(), name));
        try {
            SessionQueueQueryResponseMessage response = this.session.queueQuery(queueName);
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot unsubscribe, subscription with name " + name + " does not exist");
            }
            if (response.getConsumerCount() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + name + " since it has active subscribers");
            }
            this.session.deleteQueue(queueName);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public Session getSession() throws JMSException {
        if (!this.xa) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue, messageSelector);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "JBossSession->" + this.session;
    }

    public ClientSession getCoreSession() {
        return this.session;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public void deleteTemporaryTopic(JBossTemporaryTopic tempTopic) throws JMSException {
        try {
            SessionBindingQueryResponseMessage response = this.session.bindingQuery(tempTopic.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary topic " + tempTopic.getName() + " does not exist");
            }
            if (response.getQueueNames().size() > 1) {
                throw new IllegalStateException("Cannot delete temporary topic " + tempTopic.getName() + " since it has subscribers");
            }
            SimpleString address = tempTopic.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void deleteTemporaryQueue(JBossTemporaryQueue tempQueue) throws JMSException {
        try {
            SessionQueueQueryResponseMessage response = this.session.queueQuery(tempQueue.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary queue " + tempQueue.getName() + " does not exist");
            }
            if (response.getConsumerCount() > 0) {
                throw new IllegalStateException("Cannot delete temporary queue " + tempQueue.getName() + " since it has subscribers");
            }
            SimpleString address = tempQueue.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void deleteQueue(SimpleString queueName) throws JMSException {
        try {
            this.session.deleteQueue(queueName);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.session.start();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.session.stop();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void removeConsumer(JBossMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private void checkClosed() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }
}

