/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.JBossQueue;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.jms.client.SelectorTranslator;
import org.jboss.messaging.utils.SimpleString;

public class JBossQueueBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(JBossQueueBrowser.class);
    private static final long NEXT_MESSAGE_TIMEOUT = 1000L;
    private ClientSession session;
    private ClientConsumer consumer;
    private JBossQueue queue;
    private SimpleString filterString;

    public JBossQueueBrowser(JBossQueue queue, String messageSelector, ClientSession session) throws JMSException {
        this.session = session;
        this.queue = queue;
        if (messageSelector != null) {
            this.filterString = new SimpleString(SelectorTranslator.convertToJBMFilterString(messageSelector));
        }
    }

    public void close() throws JMSException {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (MessagingException e) {
                throw JMSExceptionHelper.convertFromMessagingException(e);
            }
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        try {
            this.close();
            this.consumer = this.session.createConsumer(this.queue.getSimpleAddress(), this.filterString, true);
            return new BrowserEnumeration();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.filterString == null ? null : this.filterString.toString();
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "JBossQueueBrowser->" + this.consumer;
    }

    private class BrowserEnumeration
    implements Enumeration {
        ClientMessage current = null;

        private BrowserEnumeration() {
        }

        public boolean hasMoreElements() {
            if (this.current == null) {
                try {
                    this.current = JBossQueueBrowser.this.consumer.receive(1000L);
                }
                catch (MessagingException e) {
                    return false;
                }
            }
            return this.current != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ClientMessage next = this.current;
                this.current = null;
                JBossMessage jbm = JBossMessage.createMessage(next, JBossQueueBrowser.this.session);
                try {
                    jbm.doBeforeReceive();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to create message", (Throwable)e);
                    return null;
                }
                return jbm;
            }
            throw new NoSuchElementException();
        }
    }
}

