/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import java.util.concurrent.atomic.AtomicLong;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientProducer;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.jms.client.JBossBytesMessage;
import org.jboss.messaging.jms.client.JBossConnection;
import org.jboss.messaging.jms.client.JBossMapMessage;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.jms.client.JBossObjectMessage;
import org.jboss.messaging.jms.client.JBossStreamMessage;
import org.jboss.messaging.jms.client.JBossTextMessage;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.utils.SimpleString;
import org.jboss.messaging.utils.UUIDGenerator;

public class JBossMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private static final Logger log = Logger.getLogger(JBossMessageProducer.class);
    private JBossConnection jbossConn;
    private final SimpleString connID;
    private ClientProducer producer;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private JBossDestination defaultDestination;
    private final String messageIDPrefix;
    private final AtomicLong sequenceNumber = new AtomicLong(0L);
    private ClientSession clientSession;

    public JBossMessageProducer(JBossConnection jbossConn, ClientProducer producer, JBossDestination defaultDestination, ClientSession clientSession) throws JMSException {
        this.jbossConn = jbossConn;
        this.connID = jbossConn.getUID();
        this.producer = producer;
        this.defaultDestination = defaultDestination;
        this.clientSession = clientSession;
        String uuid = UUIDGenerator.getInstance().generateSimpleStringUUID().toString();
        this.messageIDPrefix = "ID:" + uuid + ":";
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        this.defaultDeliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        this.defaultPriority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    public void close() throws JMSException {
        try {
            this.producer.close();
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void send(javax.jms.Message message) throws JMSException {
        this.checkClosed();
        message.setJMSDeliveryMode(this.defaultDeliveryMode);
        message.setJMSPriority(this.defaultPriority);
        this.doSend(message, this.defaultTimeToLive, null);
    }

    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.doSend(message, timeToLive, null);
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.checkClosed();
        if (destination != null && !(destination instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBoss Destination:" + destination);
        }
        message.setJMSDeliveryMode(this.defaultDeliveryMode);
        message.setJMSPriority(this.defaultPriority);
        this.doSend(message, this.defaultTimeToLive, (JBossDestination)destination);
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        if (destination != null && !(destination instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBoss Destination:" + destination);
        }
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        this.doSend(message, timeToLive, (JBossDestination)destination);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "JBossMessageProducer->" + this.producer;
    }

    private void doSend(javax.jms.Message message, long timeToLive, JBossDestination destination) throws JMSException {
        JBossMessage jbm;
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            message.setJMSTimestamp(System.currentTimeMillis());
        } else {
            message.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new InvalidDestinationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new JMSException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            address = destination.getSimpleAddress();
        }
        boolean foreign = false;
        if (!(message instanceof JBossMessage)) {
            jbm = message instanceof BytesMessage ? new JBossBytesMessage((BytesMessage)message, this.clientSession) : (message instanceof MapMessage ? new JBossMapMessage((MapMessage)message, this.clientSession) : (message instanceof ObjectMessage ? new JBossObjectMessage((ObjectMessage)message, this.clientSession) : (message instanceof StreamMessage ? new JBossStreamMessage((StreamMessage)message, this.clientSession) : (message instanceof TextMessage ? new JBossTextMessage((TextMessage)message, this.clientSession) : new JBossMessage(message, this.clientSession)))));
            message.setJMSDestination((Destination)destination);
            foreign = true;
        } else {
            jbm = (JBossMessage)message;
        }
        if (!this.disableMessageID) {
            jbm.setJMSMessageID(this.messageIDPrefix + this.sequenceNumber.incrementAndGet());
        }
        if (foreign) {
            message.setJMSMessageID(jbm.getJMSMessageID());
        }
        jbm.setJMSDestination(destination);
        try {
            jbm.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
        ClientMessage coreMessage = jbm.getCoreMessage();
        if (this.jbossConn.hasNoLocal()) {
            coreMessage.putStringProperty(JBossConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        }
        try {
            this.producer.send(address, (Message)coreMessage);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    private void checkClosed() throws JMSException {
        if (this.producer.isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
    }
}

