/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.MessageHandler;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.jms.client.JBossSession;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.jms.client.JMSMessageListenerWrapper;
import org.jboss.messaging.utils.SimpleString;

public class JBossMessageConsumer
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    private static final Logger log = Logger.getLogger(JBossMessageConsumer.class);
    private final ClientConsumer consumer;
    private MessageListener listener;
    private MessageHandler coreListener;
    private final JBossSession session;
    private final int ackMode;
    private final boolean noLocal;
    private final JBossDestination destination;
    private final String selector;
    private final SimpleString autoDeleteQueueName;

    public JBossMessageConsumer(JBossSession session, ClientConsumer consumer, boolean noLocal, JBossDestination destination, String selector, SimpleString autoDeleteQueueName) throws JMSException {
        this.session = session;
        this.consumer = consumer;
        this.ackMode = session.getAcknowledgeMode();
        this.noLocal = noLocal;
        this.destination = destination;
        this.selector = selector;
        this.autoDeleteQueueName = autoDeleteQueueName;
    }

    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = listener;
        this.coreListener = new JMSMessageListenerWrapper(this.session, this.consumer, listener, this.ackMode);
        try {
            this.consumer.setMessageHandler(this.coreListener);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public Message receive() throws JMSException {
        return this.getMessage(0L);
    }

    public Message receive(long timeout) throws JMSException {
        return this.getMessage(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.getMessage(-1L);
    }

    public void close() throws JMSException {
        try {
            this.consumer.close();
            if (this.autoDeleteQueueName != null) {
                this.session.deleteQueue(this.autoDeleteQueueName);
            }
            this.session.removeConsumer(this);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.destination;
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.destination;
    }

    public boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    public String toString() {
        return "JBossMessageConsumer->" + this.consumer;
    }

    private void checkClosed() throws JMSException {
        if (this.session.getCoreSession().isClosed()) {
            throw new IllegalStateException("Consumer is closed");
        }
    }

    private JBossMessage getMessage(long timeout) throws JMSException {
        try {
            ClientMessage message = this.consumer.receive(timeout);
            JBossMessage jbm = null;
            if (message != null) {
                message.acknowledge();
                jbm = JBossMessage.createMessage(message, this.ackMode == 2 ? this.session.getCoreSession() : null);
                try {
                    jbm.doBeforeReceive();
                }
                catch (Exception e) {
                    log.error((Object)"Failed to prepare message", (Throwable)e);
                    return null;
                }
            }
            return jbm;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }
}

