/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.jboss.messaging.core.buffers.ChannelBuffers;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.client.impl.ClientMessageImpl;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.message.impl.MessageImpl;
import org.jboss.messaging.core.remoting.spi.MessagingBuffer;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.jms.client.JBossBytesMessage;
import org.jboss.messaging.jms.client.JBossMapMessage;
import org.jboss.messaging.jms.client.JBossObjectMessage;
import org.jboss.messaging.jms.client.JBossStreamMessage;
import org.jboss.messaging.jms.client.JBossTextMessage;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.utils.SimpleString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossMessage
implements Message {
    public static final SimpleString REPLYTO_HEADER_NAME = ClientMessageImpl.REPLYTO_HEADER_NAME;
    public static final SimpleString CORRELATIONID_HEADER_NAME = new SimpleString("JMSCorrelationID");
    public static final SimpleString JBM_MESSAGE_ID = new SimpleString("JMSMessageID");
    public static final SimpleString TYPE_HEADER_NAME = new SimpleString("JMSType");
    private static final SimpleString JMS = new SimpleString("JMS");
    private static final SimpleString JMSX = new SimpleString("JMSX");
    private static final SimpleString JMS_ = new SimpleString("JMS_");
    public static final String JMSXDELIVERYCOUNT = "JMSXDeliveryCount";
    public static final String JMS_JBM_INPUT_STREAM = "JMS_JBM_InputStream";
    public static final String JMS_JBM_OUTPUT_STREAM = "JMS_JBM_OutputStream";
    public static final String JMS_JBM_SAVE_STREAM = "JMS_JBM_SaveStream";
    public static final String JMSXGROUPID = "JMSXGroupID";
    public static final String JBOSS_MESSAGING_BRIDGE_MESSAGE_ID_LIST = "JBM_BRIDGE_MSG_ID_LIST";
    public static final byte TYPE = 0;
    private static final HashSet<String> reservedIdentifiers = new HashSet();
    private static final Logger log;
    protected ClientMessage message;
    private ClientSession session;
    protected boolean readOnly;
    protected boolean propertiesReadOnly;
    private Destination dest;
    private String msgID;
    private Destination replyTo;
    private String jmsCorrelationID;
    private String jmsType;

    public static Map<String, Object> coreMaptoJMSMap(Map<String, Object> coreMessage) {
        HashMap<String, Object> jmsMessage = new HashMap<String, Object>();
        String deliveryMode = (Boolean)coreMessage.get("durable") != false ? "PERSISTENT" : "NON_PERSISTENT";
        byte priority = (Byte)coreMessage.get("priority");
        long timestamp = (Long)coreMessage.get("timestamp");
        long expiration = (Long)coreMessage.get("expiration");
        jmsMessage.put("JMSPriority", priority);
        jmsMessage.put("JMSTimestamp", timestamp);
        jmsMessage.put("JMSExpiration", expiration);
        jmsMessage.put("JMSDeliveryMode", deliveryMode);
        for (Map.Entry<String, Object> entry : coreMessage.entrySet()) {
            if (entry.getKey().equals("messageID") || entry.getKey().equals("destination") || entry.getKey().equals("type") || entry.getKey().equals("durable") || entry.getKey().equals("expiration") || entry.getKey().equals("timestamp") || entry.getKey().equals("priority")) continue;
            Object value = entry.getValue();
            if (value instanceof SimpleString) {
                jmsMessage.put(entry.getKey(), value.toString());
                continue;
            }
            jmsMessage.put(entry.getKey(), value);
        }
        return jmsMessage;
    }

    public static JBossMessage createMessage(ClientMessage message, ClientSession session) {
        JBossMessage msg;
        byte type = message.getType();
        switch (type) {
            case 0: {
                msg = new JBossMessage(message, session);
                break;
            }
            case 4: {
                msg = new JBossBytesMessage(message, session);
                break;
            }
            case 5: {
                msg = new JBossMapMessage(message, session);
                break;
            }
            case 2: {
                msg = new JBossObjectMessage(message, session);
                break;
            }
            case 6: {
                msg = new JBossStreamMessage(message, session);
                break;
            }
            case 3: {
                msg = new JBossTextMessage(message, session);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid message type " + type);
            }
        }
        return msg;
    }

    public JBossMessage() {
        this.message = new ClientMessageImpl(0, true, 0L, System.currentTimeMillis(), 4, (MessagingBuffer)ChannelBuffers.dynamicBuffer((int)1024));
    }

    public JBossMessage(byte type) {
        this.message = new ClientMessageImpl(type, true, 0L, System.currentTimeMillis(), 4, (MessagingBuffer)ChannelBuffers.dynamicBuffer((int)1024));
    }

    protected JBossMessage(byte type, ClientSession session) {
        this.message = session.createClientMessage(type, true, 0L, System.currentTimeMillis(), (byte)4);
    }

    public JBossMessage(ClientSession session) {
        this(0, session);
    }

    public JBossMessage(ClientMessage message, ClientSession session) {
        this.message = message;
        this.readOnly = true;
        this.propertiesReadOnly = true;
        this.session = session;
    }

    public JBossMessage(Message foreign, ClientSession session) throws JMSException {
        this(foreign, 0, session);
    }

    protected JBossMessage(Message foreign, byte type, ClientSession session) throws JMSException {
        block3: {
            this(type, session);
            this.setJMSTimestamp(foreign.getJMSTimestamp());
            try {
                byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
                this.setJMSCorrelationIDAsBytes(corrIDBytes);
            }
            catch (JMSException e) {
                String corrIDString = foreign.getJMSCorrelationID();
                if (corrIDString == null) break block3;
                this.setJMSCorrelationID(corrIDString);
            }
        }
        this.setJMSReplyTo(foreign.getJMSReplyTo());
        this.setJMSDestination(foreign.getJMSDestination());
        this.setJMSDeliveryMode(foreign.getJMSDeliveryMode());
        this.setJMSExpiration(foreign.getJMSExpiration());
        this.setJMSPriority(foreign.getJMSPriority());
        this.setJMSType(foreign.getJMSType());
        Enumeration props = foreign.getPropertyNames();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object prop = foreign.getObjectProperty(name);
            this.setObjectProperty(name, prop);
        }
    }

    public String getJMSMessageID() {
        if (this.msgID == null) {
            SimpleString id = (SimpleString)this.message.getProperty(JBM_MESSAGE_ID);
            this.msgID = id == null ? null : id.toString();
        }
        return this.msgID;
    }

    public void setJMSMessageID(String jmsMessageID) throws JMSException {
        if (jmsMessageID != null && !jmsMessageID.startsWith("ID:")) {
            throw new JMSException("JMSMessageID must start with ID:");
        }
        if (jmsMessageID == null) {
            this.message.removeProperty(JBM_MESSAGE_ID);
        } else {
            this.message.putStringProperty(JBM_MESSAGE_ID, new SimpleString(jmsMessageID));
        }
        this.msgID = jmsMessageID;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.message.getTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.message.setTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        Object obj = this.message.getProperty(CORRELATIONID_HEADER_NAME);
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (correlationID == null || correlationID.length == 0) {
            throw new JMSException("Please specify a non-zero length byte[]");
        }
        this.message.putBytesProperty(CORRELATIONID_HEADER_NAME, correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (correlationID == null) {
            this.message.removeProperty(CORRELATIONID_HEADER_NAME);
            this.jmsCorrelationID = null;
        } else {
            this.message.putStringProperty(CORRELATIONID_HEADER_NAME, new SimpleString(correlationID));
            this.jmsCorrelationID = correlationID;
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        Object obj;
        if (this.jmsCorrelationID == null && (obj = this.message.getProperty(CORRELATIONID_HEADER_NAME)) != null) {
            this.jmsCorrelationID = ((SimpleString)obj).toString();
        }
        return this.jmsCorrelationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        SimpleString repl;
        if (this.replyTo == null && (repl = (SimpleString)this.message.getProperty(REPLYTO_HEADER_NAME)) != null) {
            this.replyTo = JBossDestination.fromAddress(repl.toString());
        }
        return this.replyTo;
    }

    public void setJMSReplyTo(Destination dest) throws JMSException {
        if (dest == null) {
            this.message.removeProperty(REPLYTO_HEADER_NAME);
            this.replyTo = null;
        } else {
            if (!(dest instanceof JBossDestination)) {
                throw new InvalidDestinationException("Not a JBoss destination " + dest);
            }
            JBossDestination jbd = (JBossDestination)dest;
            this.message.putStringProperty(REPLYTO_HEADER_NAME, jbd.getSimpleAddress());
            this.replyTo = jbd;
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (this.dest == null) {
            SimpleString sdest = this.message.getDestination();
            this.dest = sdest == null ? null : JBossDestination.fromAddress(sdest.toString());
        }
        return this.dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.message.isDurable() ? 2 : 1;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.message.setDurable(true);
        } else if (deliveryMode == 1) {
            this.message.setDurable(false);
        } else {
            throw new JMSException("DeliveryImpl mode must be either DeliveryMode.PERSISTENT or DeliveryMode.NON_PERSISTENT");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.message.getDeliveryCount() > 1;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (!redelivered) {
            this.message.setDeliveryCount(1);
        } else if (this.message.getDeliveryCount() <= 1) {
            this.message.setDeliveryCount(2);
        }
    }

    public void setJMSType(String type) throws JMSException {
        if (type != null) {
            this.message.putStringProperty(TYPE_HEADER_NAME, new SimpleString(type));
            this.jmsType = type;
        }
    }

    public String getJMSType() throws JMSException {
        SimpleString ss;
        if (this.jmsType == null && (ss = (SimpleString)this.message.getProperty(TYPE_HEADER_NAME)) != null) {
            this.jmsType = ss.toString();
        }
        return this.jmsType;
    }

    public long getJMSExpiration() throws JMSException {
        return this.message.getExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.message.setExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.message.getPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.checkPriority(priority);
        this.message.setPriority((byte)priority);
    }

    public void clearProperties() throws JMSException {
        ArrayList<SimpleString> toRemove = new ArrayList<SimpleString>();
        for (SimpleString propName : this.message.getPropertyNames()) {
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_)) continue;
            toRemove.add(propName);
        }
        for (SimpleString propName : toRemove) {
            this.message.removeProperty(propName);
        }
        this.propertiesReadOnly = false;
    }

    public void clearBody() throws JMSException {
        this.readOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.message.containsProperty(new SimpleString(name)) || name.equals(JMSXDELIVERYCOUNT) || JMSXGROUPID.equals(name) && this.message.containsProperty(MessageImpl.HDR_GROUP_ID);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof SimpleString) {
            return Boolean.valueOf(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof SimpleString) {
            return Byte.parseByte(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof SimpleString) {
            return Short.parseShort(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getIntProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return this.message.getDeliveryCount();
        }
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof SimpleString) {
            return Integer.parseInt(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLongProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return this.message.getDeliveryCount();
        }
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            throw new NumberFormatException("Message property '" + name + "' not set.");
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof SimpleString) {
            return Long.parseLong(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof SimpleString) {
            return Float.parseFloat(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.message.getProperty(new SimpleString(name));
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof SimpleString) {
            return Double.parseDouble(((SimpleString)value).toString());
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getStringProperty(String name) throws JMSException {
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        Object value = JMSXGROUPID.equals(name) ? this.message.getProperty(MessageImpl.HDR_GROUP_ID) : this.message.getProperty(new SimpleString(name));
        if (value == null) {
            return null;
        }
        if (value instanceof SimpleString) {
            return ((SimpleString)value).toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Float) {
            return value.toString();
        }
        if (value instanceof Double) {
            return value.toString();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (JMS_JBM_INPUT_STREAM.equals(name)) {
            return this.message.getBodyInputStream();
        }
        if (JMSXDELIVERYCOUNT.equals(name)) {
            return String.valueOf(this.message.getDeliveryCount());
        }
        Object val = this.message.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    public Enumeration getPropertyNames() throws JMSException {
        HashSet<String> set = new HashSet<String>();
        for (SimpleString propName : this.message.getPropertyNames()) {
            if (propName.startsWith(JMS) && !propName.startsWith(JMSX) && !propName.startsWith(JMS_)) continue;
            set.add(propName.toString());
        }
        set.add(JMSXDELIVERYCOUNT);
        return Collections.enumeration(set);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        Boolean b = value;
        this.checkProperty(name, b);
        this.message.putBooleanProperty(new SimpleString(name), b.booleanValue());
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        Byte b = new Byte(value);
        this.checkProperty(name, b);
        this.message.putByteProperty(new SimpleString(name), value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        Short s = new Short(value);
        this.checkProperty(name, s);
        this.message.putShortProperty(new SimpleString(name), value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        Integer i = new Integer(value);
        this.checkProperty(name, i);
        this.message.putIntProperty(new SimpleString(name), value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        Long l = new Long(value);
        this.checkProperty(name, l);
        this.message.putLongProperty(new SimpleString(name), value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        Float f = new Float(value);
        this.checkProperty(name, f);
        this.message.putFloatProperty(new SimpleString(name), f.floatValue());
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        Double d = new Double(value);
        this.checkProperty(name, d);
        this.message.putDoubleProperty(new SimpleString(name), d.doubleValue());
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkProperty(name, value);
        if (JMSXGROUPID.equals(name)) {
            this.message.putStringProperty(MessageImpl.HDR_GROUP_ID, new SimpleString(value));
        } else {
            this.message.putStringProperty(new SimpleString(name), new SimpleString(value));
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (JMS_JBM_OUTPUT_STREAM.equals(name)) {
            this.setOutputStream((OutputStream)value);
            return;
        }
        if (JMS_JBM_SAVE_STREAM.equals(name)) {
            this.saveToOutputStream((OutputStream)value);
            return;
        }
        this.checkProperty(name, value);
        if (JMS_JBM_INPUT_STREAM.equals(name)) {
            this.setInputStream((InputStream)value);
            return;
        }
        SimpleString key = new SimpleString(name);
        if (value instanceof Boolean) {
            this.message.putBooleanProperty(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Byte) {
            this.message.putByteProperty(key, ((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.message.putShortProperty(key, ((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.message.putIntProperty(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.message.putLongProperty(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            this.message.putFloatProperty(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.message.putDoubleProperty(key, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            this.message.putStringProperty(key, new SimpleString((String)value));
        } else {
            throw new MessageFormatException("Invalid property type");
        }
    }

    public void acknowledge() throws JMSException {
        if (this.session != null) {
            try {
                this.session.commit();
            }
            catch (MessagingException e) {
                throw JMSExceptionHelper.convertFromMessagingException(e);
            }
        }
    }

    public ClientMessage getCoreMessage() {
        return this.message;
    }

    public void doBeforeSend() throws Exception {
        this.message.getBody().resetReaderIndex();
    }

    public void doBeforeReceive() throws Exception {
        MessagingBuffer body = this.message.getBody();
        if (body != null) {
            body.resetReaderIndex();
        }
    }

    public byte getType() {
        return 0;
    }

    public void setInputStream(InputStream input) throws JMSException {
        this.checkStream();
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message is read-only");
        }
        this.message.setBodyInputStream(input);
    }

    public void setOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.setOutputStream(output);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public void saveToOutputStream(OutputStream output) throws JMSException {
        this.checkStream();
        if (!this.readOnly) {
            throw new IllegalStateException("OutputStream property is only valid on received messages");
        }
        try {
            this.message.saveToOutputStream(output);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public boolean waitCompletionOnStream(long timeWait) throws JMSException {
        this.checkStream();
        try {
            return this.message.waitOutputStreamCompletion(timeWait);
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JBossMessage[");
        sb.append("");
        sb.append(this.getJMSMessageID());
        sb.append("]:");
        sb.append(this.message.isDurable() ? "PERSISTENT" : "NON-PERSISTENT");
        return sb.toString();
    }

    protected void checkWrite() throws JMSException {
        if (this.readOnly) {
            throw new MessageNotWriteableException("Message is read-only");
        }
    }

    protected void checkRead() throws JMSException {
        if (!this.readOnly) {
            throw new MessageNotReadableException("Message is write-only");
        }
    }

    protected MessagingBuffer getBody() {
        return this.message.getBody();
    }

    private void checkStream() throws JMSException {
        if (this.message.getType() != 4 && this.message.getType() != 6) {
            throw new IllegalStateException("LargeMessage streaming is only possible on ByteMessage or StreamMessage");
        }
    }

    private void checkProperty(String name, Object value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Message is read-only");
        }
        if (name == null) {
            throw new IllegalArgumentException("The name of a property must not be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("The name of a property must not be an empty String.");
        }
        if (!this.isValidJavaIdentifier(name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is not a valid java identifier.");
        }
        if (reservedIdentifiers.contains(name)) {
            throw new IllegalArgumentException("The property name '" + name + "' is reserved due to selector syntax.");
        }
        if (name.startsWith("JMS")) {
            if (name.length() > 3) {
                char c = name.charAt(3);
                if (c != 'X' && c != '_') {
                    throw new IllegalArgumentException("The property name '" + name + "' is illegal since it starts with JMS");
                }
            } else {
                throw new IllegalArgumentException("The property name '" + name + "' is illegal since it starts with JMS");
            }
        }
    }

    private boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    private void checkPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException(priority + " is not valid: priority must be between 0 and 9");
        }
    }

    static {
        reservedIdentifiers.add("NULL");
        reservedIdentifiers.add("TRUE");
        reservedIdentifiers.add("FALSE");
        reservedIdentifiers.add("NOT");
        reservedIdentifiers.add("AND");
        reservedIdentifiers.add("OR");
        reservedIdentifiers.add("BETWEEN");
        reservedIdentifiers.add("LIKE");
        reservedIdentifiers.add("IN");
        reservedIdentifiers.add("IS");
        reservedIdentifiers.add("ESCAPE");
        log = Logger.getLogger(JBossMessage.class);
    }
}

