/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms.client;

import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.client.ClientSessionFactory;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.FailureListener;
import org.jboss.messaging.core.version.Version;
import org.jboss.messaging.jms.client.JBossConnectionMetaData;
import org.jboss.messaging.jms.client.JBossSession;
import org.jboss.messaging.jms.client.JMSExceptionHelper;
import org.jboss.messaging.utils.ConcurrentHashSet;
import org.jboss.messaging.utils.SimpleString;
import org.jboss.messaging.utils.UUIDGenerator;
import org.jboss.messaging.utils.VersionLoader;

public class JBossConnection
implements Connection,
QueueConnection,
TopicConnection,
XAConnection,
XAQueueConnection,
XATopicConnection {
    private static final Logger log = Logger.getLogger(JBossConnection.class);
    public static final int TYPE_GENERIC_CONNECTION = 0;
    public static final int TYPE_QUEUE_CONNECTION = 1;
    public static final int TYPE_TOPIC_CONNECTION = 2;
    public static final SimpleString CONNECTION_ID_PROPERTY_NAME = new SimpleString("__JBM_CID");
    private final int connectionType;
    private final Set<JBossSession> sessions = new ConcurrentHashSet();
    private final Set<SimpleString> tempQueues = new ConcurrentHashSet();
    private volatile boolean hasNoLocal;
    private volatile ExceptionListener exceptionListener;
    private volatile boolean justCreated = true;
    private volatile ConnectionMetaData metaData;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private final ClientSessionFactory sessionFactory;
    private final SimpleString uid;
    private final String username;
    private final String password;
    private final FailureListener listener = new JMSFailureListener();
    private final Version thisVersion;
    private final int dupsOKBatchSize;
    private final int transactionBatchSize;
    private ClientSession initialSession;

    public JBossConnection(String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, ClientSessionFactory sessionFactory) {
        this.username = username;
        this.password = password;
        this.connectionType = connectionType;
        this.clientID = clientID;
        this.sessionFactory = sessionFactory;
        this.uid = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.thisVersion = VersionLoader.getVersion();
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.transactionBatchSize = transactionBatchSize;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 0);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        if (this.clientID != null) {
            throw new IllegalStateException("Client id has already been set");
        }
        if (!this.justCreated) {
            throw new IllegalStateException("setClientID can only be called directly after the connection is created");
        }
        this.clientID = clientID;
        this.justCreated = false;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        if (this.metaData == null) {
            this.metaData = new JBossConnectionMetaData(this.thisVersion);
        }
        return this.metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
        this.justCreated = false;
    }

    public void start() throws JMSException {
        this.checkClosed();
        for (JBossSession session : this.sessions) {
            session.start();
        }
        this.justCreated = false;
        this.started = true;
    }

    public void stop() throws JMSException {
        this.checkClosed();
        for (JBossSession session : this.sessions) {
            session.stop();
        }
        this.justCreated = false;
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        try {
            for (JBossSession session : new HashSet<JBossSession>(this.sessions)) {
                session.close();
            }
            try {
                if (!this.tempQueues.isEmpty()) {
                    if (this.initialSession == null) {
                        this.initialSession = this.sessionFactory.createSession(this.username, this.password, false, true, true, false, 0);
                    }
                    for (SimpleString queueName : this.tempQueues) {
                        this.initialSession.deleteQueue(queueName);
                    }
                }
            }
            finally {
                if (this.initialSession != null) {
                    this.initialSession.close();
                }
            }
            this.closed = true;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.connectionType == 1) {
            String msg = "Cannot create a durable connection consumer on a QueueConnection";
            throw new IllegalStateException(msg);
        }
        return null;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 1);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return null;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 2);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        return null;
    }

    public XASession createXASession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 0);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 1);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 2);
    }

    public void addTemporaryQueue(SimpleString queueName) {
        this.tempQueues.add(queueName);
    }

    public void removeTemporaryQueue(SimpleString queueName) {
        this.tempQueues.remove(queueName);
    }

    public boolean hasNoLocal() {
        return this.hasNoLocal;
    }

    public void setHasNoLocal() {
        this.hasNoLocal = true;
    }

    public SimpleString getUID() {
        return this.uid;
    }

    public void removeSession(JBossSession session) {
        this.sessions.remove(session);
    }

    public ClientSession getInitialSession() {
        return this.initialSession;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected JBossSession createSessionInternal(boolean transacted, int acknowledgeMode, boolean isXA, int type) throws JMSException {
        if (transacted) {
            acknowledgeMode = 0;
        }
        try {
            ClientSession session;
            if (acknowledgeMode == 0) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, false, false, false, this.transactionBatchSize);
            } else if (acknowledgeMode == 1) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, false, 0);
            } else if (acknowledgeMode == 3) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, false, this.dupsOKBatchSize);
            } else if (acknowledgeMode == 2) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, false, this.transactionBatchSize);
            } else if (acknowledgeMode == 100) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, true, this.transactionBatchSize);
            } else {
                throw new IllegalArgumentException("Invalid ackmode: " + acknowledgeMode);
            }
            this.justCreated = false;
            session.addFailureListener(this.listener);
            JBossSession jbs = new JBossSession(this, transacted, isXA, acknowledgeMode, session, type);
            this.sessions.add(jbs);
            if (this.started) {
                session.start();
            }
            return jbs;
        }
        catch (MessagingException e) {
            throw JMSExceptionHelper.convertFromMessagingException(e);
        }
    }

    private void checkClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public void authorize() throws JMSException {
        try {
            this.initialSession = this.sessionFactory.createSession(this.username, this.password, false, false, false, false, 0);
            this.initialSession.addFailureListener(this.listener);
        }
        catch (MessagingException me) {
            throw JMSExceptionHelper.convertFromMessagingException(me);
        }
    }

    private class JMSFailureListener
    implements FailureListener {
        private boolean failed;

        private JMSFailureListener() {
        }

        public synchronized boolean connectionFailed(MessagingException me) {
            if (this.failed) {
                return true;
            }
            if (me == null) {
                return true;
            }
            if (JBossConnection.this.exceptionListener != null) {
                JMSException je = new JMSException(me.toString());
                je.initCause((Throwable)me);
                JBossConnection.this.exceptionListener.onException(je);
            }
            this.failed = true;
            return true;
        }
    }
}

