/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms;

import javax.jms.JMSException;
import javax.jms.Queue;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.utils.SimpleString;

public class JBossQueue
extends JBossDestination
implements Queue {
    private static final Logger log = Logger.getLogger(JBossQueue.class);
    private static final long serialVersionUID = -1106092883162295462L;
    public static final String JMS_QUEUE_ADDRESS_PREFIX = "jms.queue.";

    public static SimpleString createAddressFromName(String name) {
        return new SimpleString(JMS_QUEUE_ADDRESS_PREFIX + name);
    }

    public JBossQueue(String name) {
        super(JMS_QUEUE_ADDRESS_PREFIX + name, name);
    }

    public JBossQueue(String address, String name) {
        super(address, name);
    }

    public String getQueueName() throws JMSException {
        return this.name;
    }

    public boolean isTemporary() {
        return false;
    }

    public String toString() {
        return "JBossQueue[" + this.name + "]";
    }
}

