/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.jms;

import java.io.Serializable;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.jboss.messaging.jms.JBossQueue;
import org.jboss.messaging.jms.JBossTemporaryQueue;
import org.jboss.messaging.jms.JBossTemporaryTopic;
import org.jboss.messaging.jms.JBossTopic;
import org.jboss.messaging.jms.referenceable.DestinationObjectFactory;
import org.jboss.messaging.jms.referenceable.SerializableObjectRefAddr;
import org.jboss.messaging.utils.SimpleString;

public abstract class JBossDestination
implements Destination,
Serializable {
    protected final String name;
    private final String address;
    private final SimpleString simpleAddress;

    protected static String escape(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static JBossDestination fromAddress(String address) {
        if (address.startsWith("jms.queue.")) {
            String name = address.substring("jms.queue.".length());
            return new JBossQueue(address, name);
        }
        if (address.startsWith("jms.topic.")) {
            String name = address.substring("jms.topic.".length());
            return new JBossTopic(address, name);
        }
        if (address.startsWith("jms.tempqueue.")) {
            String name = address.substring("jms.tempqueue.".length());
            return new JBossTemporaryQueue(null, name);
        }
        if (address.startsWith("jms.temptopic.")) {
            String name = address.substring("jms.temptopic.".length());
            return new JBossTemporaryTopic(null, name);
        }
        throw new IllegalArgumentException("Invalid address " + address);
    }

    public JBossDestination(String address, String name) {
        this.address = address;
        this.name = name;
        this.simpleAddress = new SimpleString(address);
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getCanonicalName(), new SerializableObjectRefAddr("JBM-DEST", this), DestinationObjectFactory.class.getCanonicalName(), null);
    }

    public String getAddress() {
        return this.address;
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isTemporary();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JBossDestination)) {
            return false;
        }
        JBossDestination that = (JBossDestination)o;
        return this.address.equals(that.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

