/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RegisteredAttributesHandler;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.xml.sax.Attributes;

public class BeanHandler
implements ParticleHandler {
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private String name;
    private BeanAdapterFactory beanAdapterFactory;
    private RegisteredAttributesHandler attrsHandler = new RegisteredAttributesHandler();

    public BeanHandler(String name, BeanAdapterFactory beanAdapterFactory) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (beanAdapterFactory == null) {
            throw new IllegalArgumentException("Null bean adapter factory");
        }
        this.name = name;
        this.beanAdapterFactory = beanAdapterFactory;
    }

    public BeanAdapterFactory getBeanAdapterFactory() {
        return this.beanAdapterFactory;
    }

    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (this.trace) {
            this.log.trace((Object)(" startElement " + elementName + " bean=" + this.name + " parent=" + BuilderUtil.toDebugString(parent)));
        }
        BeanAdapter o = null;
        try {
            o = this.beanAdapterFactory.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + elementName + " error invoking beanAdapterFactory.newInstance() for bean=" + this.name, t);
        }
        TermBinding term = particle.getTerm();
        if (o != null && term.isElement()) {
            ElementBinding element = (ElementBinding)term;
            this.attrsHandler.attributes(o, elementName, element.getType(), attrs, nsCtx);
        }
        return o;
    }

    public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle) {
        if (this.trace) {
            this.log.trace((Object)("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
        }
        TermBinding term = particle.getTerm();
        ValueAdapter valueAdapter = null;
        if (term.isModelGroup()) {
            QName modelGroupName = ((ModelGroupBinding)term).getQName();
            if (modelGroupName != null) {
                qName = modelGroupName;
            }
        } else if (term.isElement()) {
            valueAdapter = ((ElementBinding)term).getValueAdapter();
        }
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        AbstractPropertyHandler propertyHandler = beanAdapter.getPropertyHandler(qName);
        if (propertyHandler == null) {
            TermBinding element = term;
            if (element.getSchema().isStrictSchema()) {
                throw new RuntimeException("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + beanAdapter.getAvailable());
            }
            if (this.trace) {
                this.log.trace((Object)("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
            }
            return;
        }
        if (valueAdapter != null) {
            o = valueAdapter.cast(o, null);
        }
        propertyHandler.doHandle(beanAdapter, o, qName);
    }

    public Object endParticle(Object o, QName qName, ParticleBinding particle) {
        if (this.trace) {
            this.log.trace((Object)("endElement " + qName + " o=" + BuilderUtil.toDebugString(o)));
        }
        BeanAdapter beanAdapter = (BeanAdapter)o;
        return beanAdapter.getValue();
    }

    public RegisteredAttributesHandler getAttributesHandler() {
        return this.attrsHandler;
    }
}

