/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.PositionStack;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnmarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.position.AbstractPosition;
import org.jboss.xb.binding.sunday.unmarshalling.position.ElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.position.Position;
import org.xml.sax.Attributes;

public class SundayContentHandler
implements JBossXBParser.DtdAwareContentHandler,
PositionStack {
    static final Logger log = Logger.getLogger(SundayContentHandler.class);
    public static final Object NIL = new Object();
    private final SchemaBindingResolver schemaResolver;
    private final SchemaBinding schema;
    private Position head;
    private String dtdRootName;
    private String dtdPublicId;
    private String dtdSystemId;
    private boolean sawDTD;
    private boolean trace = log.isTraceEnabled();
    private UnmarshallingContextImpl ctx = new UnmarshallingContextImpl();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    public SundayContentHandler(SchemaBinding schema) {
        this.schema = schema;
        this.schemaResolver = null;
        AbstractPosition.resetTrace();
    }

    public SundayContentHandler(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
        this.schema = null;
        AbstractPosition.resetTrace();
    }

    public void startDTD(String dtdRootName, String dtdPublicId, String dtdSystemId) {
        this.dtdRootName = dtdRootName;
        this.dtdPublicId = dtdPublicId;
        this.dtdSystemId = dtdSystemId;
    }

    public void endDTD() {
        this.sawDTD = true;
    }

    public void characters(char[] ch, int start, int length) {
        if (!this.head.isElement()) {
            return;
        }
        Position position = this.head;
        if (position.isEnded()) {
            position = position.getPrevious();
            while (!position.isElement()) {
                position = position.getPrevious();
            }
        }
        position.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        while (this.head != null) {
            if (this.head.isElement()) {
                if (!this.head.isEnded()) {
                    QName endName;
                    QName elementQName = this.head.getParticle().getTerm().getQName();
                    QName qName2 = endName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
                    if (!elementQName.equals(endName)) {
                        throw new JBossXBRuntimeException("Failed to end element " + new QName(namespaceURI, localName) + ": element on the stack is " + elementQName);
                    }
                    this.head.endParticle();
                    break;
                }
                if (this.head.getRepeatableParticleValue() != null) {
                    this.head.endRepeatableParticle();
                }
            } else {
                this.head.endParticle();
            }
            this.head = this.head.getPrevious();
        }
        if (this.head == null) {
            throw new JBossXBRuntimeException("Failed to endElement " + qName + ": binding not found");
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        QName startName = localName.length() == 0 ? new QName(qName) : new QName(namespaceURI, localName);
        SchemaBinding schemaBinding = this.schema;
        atts = this.preprocessAttributes(atts);
        if (this.head == null) {
            ParticleBinding particle = null;
            if (schemaBinding != null) {
                particle = schemaBinding.getElementParticle(startName);
            }
            if (particle == null && this.schemaResolver != null) {
                String schemaLocation;
                String string = schemaLocation = atts == null ? null : Util.getSchemaLocation(atts, namespaceURI);
                if (schemaLocation == null || schemaLocation.length() == 0) {
                    if (this.sawDTD) {
                        schemaLocation = this.dtdSystemId;
                    }
                    if (schemaLocation == null && (namespaceURI == null || namespaceURI.length() == 0)) {
                        schemaLocation = localName;
                    }
                }
                if ((schemaBinding = this.schemaResolver.resolve(namespaceURI, null, schemaLocation)) != null) {
                    particle = schemaBinding.getElementParticle(startName);
                } else {
                    throw new JBossXBRuntimeException("Failed to resolve schema nsURI=" + namespaceURI + " location=" + schemaLocation);
                }
            }
            if (particle == null) {
                StringBuffer sb = new StringBuffer();
                sb.append("Failed to resolve global element ");
                sb.append(startName);
                if (schemaBinding == null && this.schemaResolver == null) {
                    sb.append(". Neither SchemaBinding nor SchemaBindingResolver are available.");
                }
                throw new JBossXBRuntimeException(sb.toString());
            }
            ElementPosition next = new ElementPosition(startName, particle);
            next.setStack(this);
            next.push(atts);
            this.head = next;
            return;
        }
        while (this.head != null) {
            ElementPosition next = this.head.startParticle(startName, atts);
            if (next != null) {
                next.push(atts);
                this.head = next;
                break;
            }
            this.head = this.head.getPrevious();
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsRegistry.addPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.nsRegistry.removePrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) {
    }

    public Object getRoot() {
        Object root;
        block4: {
            if (this.head.getPrevious() != null) {
                throw new IllegalStateException("The stack still contains positions!");
            }
            ElementBinding elementBinding = (ElementBinding)this.head.getParticle().getTerm();
            root = elementBinding.getType().getValueAdapter().cast(this.head.getValue(), Object.class);
            this.head = null;
            if (this.sawDTD) {
                try {
                    Class[] sig = new Class[]{String.class, String.class, String.class};
                    Method setDTD = root.getClass().getMethod("setDTD", sig);
                    Object[] args = new Object[]{this.dtdRootName, this.dtdPublicId, this.dtdSystemId};
                    setDTD.invoke(root, args);
                }
                catch (Exception e) {
                    if (!this.trace) break block4;
                    log.trace((Object)("No setDTD found on root: " + root));
                }
            }
        }
        return root;
    }

    private Attributes preprocessAttributes(Attributes attrs) {
        SchemaBindingResolver resolver;
        SchemaBindingResolver schemaBindingResolver = resolver = this.schemaResolver == null ? this.schema.getSchemaResolver() : this.schemaResolver;
        if (resolver == null || !(resolver instanceof MutableSchemaResolver)) {
            return attrs;
        }
        int ind = attrs.getIndex("http://www.jboss.org/xml/ns/jbxb", "schemabinding");
        if (ind != -1) {
            MutableSchemaResolver defaultResolver = (MutableSchemaResolver)resolver;
            String value = attrs.getValue(ind);
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreTokens()) {
                String uri = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new JBossXBRuntimeException("jbxb:schemabinding attribute value is invalid: ns uri '" + uri + "' is missing value in '" + value + "'");
                }
                String cls = tokenizer.nextToken();
                try {
                    defaultResolver.mapURIToClass(uri, cls);
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to addClassBinding: uri='" + uri + "', class='" + cls + "'", e);
                }
            }
            AttributesImpl attrsImpl = new AttributesImpl(attrs.getLength() - 1);
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (i == ind) continue;
                attrsImpl.add(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
            attrs = attrsImpl;
        }
        return attrs;
    }

    public UnmarshallingContextImpl getContext() {
        return this.ctx;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.nsRegistry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmarshallingContextImpl
    implements UnmarshallingContext {
        public Object parent;
        public ParticleBinding particle;
        public ParticleBinding parentParticle;

        @Override
        public Object getParentValue() {
            return this.parent;
        }

        @Override
        public ParticleBinding getParticle() {
            return this.particle;
        }

        @Override
        public ParticleBinding getParentParticle() {
            return this.parentParticle;
        }

        @Override
        public String resolvePropertyName() {
            String prop;
            TermBinding term = this.particle.getTerm();
            PropertyMetaData propertyMetaData = term.getPropertyMetaData();
            String string = prop = propertyMetaData == null ? null : propertyMetaData.getName();
            if (prop != null) {
                return prop;
            }
            if (term.isElement()) {
                QName name = ((ElementBinding)term).getQName();
                prop = Util.xmlNameToFieldName(name.getLocalPart(), term.getSchema().isIgnoreLowLine());
            }
            return prop;
        }

        @Override
        public Class<?> resolvePropertyType() {
            FieldInfo fieldInfo;
            if (this.parent == null) {
                return null;
            }
            String prop = this.resolvePropertyName();
            if (prop != null && (fieldInfo = FieldInfo.getFieldInfo(this.parent.getClass(), prop, false)) != null) {
                return fieldInfo.getType();
            }
            return null;
        }

        public void clear() {
            this.parent = null;
            this.particle = null;
            this.parentParticle = null;
        }
    }
}

