/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelGroupBinding
extends TermBinding {
    protected boolean requiredParticle;
    protected ParticleHandler handler = DefaultHandlers.MODEL_GROUP_HANDLER;

    protected ModelGroupBinding(SchemaBinding schema) {
        super(schema);
    }

    public ParticleHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ParticleHandler handler) {
        this.handler = handler;
    }

    public abstract ElementBinding getArrayItem();

    public void addParticle(ParticleBinding particle) {
        if (particle.isRequired()) {
            this.requiredParticle = true;
        }
    }

    public abstract Collection<ParticleBinding> getParticles();

    public boolean hasRequiredParticle() {
        return this.requiredParticle;
    }

    public ElementBinding getElement(QName qName, Attributes attrs, boolean ignoreWildcards) {
        ElementBinding element = null;
        for (ParticleBinding nextParticle : this.getParticles()) {
            TermBinding item = nextParticle.getTerm();
            if (item.isElement()) {
                ElementBinding choice = (ElementBinding)item;
                if (qName.equals(choice.getQName())) {
                    element = choice;
                }
            } else if (item.isModelGroup()) {
                ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                element = modelGroup.getElement(qName, attrs, ignoreWildcards);
            } else if (!ignoreWildcards) {
                WildcardBinding wildcard = (WildcardBinding)item;
                element = wildcard.getElement(qName, attrs);
            }
            if (element == null) continue;
            break;
        }
        return element;
    }

    @Override
    public boolean isSkip() {
        return this.skip == null || this.skip != false;
    }

    @Override
    public boolean isModelGroup() {
        return true;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isElement() {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getGroupType());
        if (this.qName != null) {
            sb.append(' ').append(this.qName);
        }
        sb.append(':');
        for (ParticleBinding p : this.getParticles()) {
            TermBinding t = p.getTerm();
            sb.append(' ');
            if (t.isElement()) {
                sb.append(((ElementBinding)t).getQName());
            } else if (t.isModelGroup()) {
                sb.append('{').append(((ModelGroupBinding)t).getGroupType());
                ModelGroupBinding group = (ModelGroupBinding)t;
                if (group.getQName() != null) {
                    sb.append(' ').append(group.getQName());
                }
                sb.append('}');
            } else {
                sb.append("{wildcard}");
            }
            if (p.getMaxOccursUnbounded()) {
                sb.append(p.getMinOccurs() == 0 ? (char)'*' : '!');
                continue;
            }
            if (p.getMinOccurs() != 0) continue;
            sb.append('?');
        }
        return sb.toString();
    }

    public abstract String getGroupType();
}

