/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.cluster.repository;

import org.jboss.ha.timestamp.TimestampDiscrepancy;
import org.jboss.ha.timestamp.TimestampDiscrepancyService;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractSynchronizationPolicy;

public class DefaultSynchronizationPolicy
extends AbstractSynchronizationPolicy {
    private TimestampDiscrepancyService timestampService;

    public TimestampDiscrepancyService getTimestampService() {
        return this.timestampService;
    }

    public void setTimestampService(TimestampDiscrepancyService timestampService) {
        this.timestampService = timestampService;
    }

    protected boolean acceptAddition(RepositoryItemMetadata toAdd, RepositoryItemMetadata joinersPrevious, boolean merge) {
        if (merge) {
            return true;
        }
        TimestampDiscrepancy addDiscrepancy = this.getTimestampDiscrepancy(toAdd.getOriginatingNode(), false);
        long adjustedTimestamp = addDiscrepancy.getMinLocalTimestamp(toAdd.getTimestamp());
        return adjustedTimestamp > System.currentTimeMillis() - this.getRemovalTrackingTime();
    }

    protected boolean acceptReincarnation(RepositoryItemMetadata reincarnation, RepositoryItemMetadata current, boolean merge) {
        TimestampDiscrepancy addDiscrepancy = this.getTimestampDiscrepancy(reincarnation.getOriginatingNode(), false);
        TimestampDiscrepancy deadDiscrepancy = this.getTimestampDiscrepancy(current.getOriginatingNode(), false);
        return DefaultSynchronizationPolicy.isChangeMoreRecent(reincarnation, current, addDiscrepancy, deadDiscrepancy, false);
    }

    protected boolean acceptRemoval(RepositoryItemMetadata current, RepositoryItemMetadata sendersView, boolean merge) {
        if (sendersView == null) {
            return false;
        }
        TimestampDiscrepancy senderTimestampDiscrepancy = this.getTimestampDiscrepancy(sendersView.getOriginatingNode(), false);
        TimestampDiscrepancy currentTimestampDiscrepancy = this.getTimestampDiscrepancy(current.getOriginatingNode(), false);
        return DefaultSynchronizationPolicy.isChangeMoreRecent(sendersView, current, senderTimestampDiscrepancy, currentTimestampDiscrepancy, true);
    }

    protected boolean acceptUpdate(RepositoryItemMetadata update, RepositoryItemMetadata current, boolean merge) {
        TimestampDiscrepancy updateDiscrepancy = this.getTimestampDiscrepancy(update.getOriginatingNode(), false);
        TimestampDiscrepancy currentTimestampDiscrepancy = this.getTimestampDiscrepancy(current.getOriginatingNode(), false);
        return DefaultSynchronizationPolicy.isChangeMoreRecent(update, current, updateDiscrepancy, currentTimestampDiscrepancy, false);
    }

    private static boolean isChangeMoreRecent(RepositoryItemMetadata toChange, RepositoryItemMetadata current, TimestampDiscrepancy senderTimestampDiscrepancy, TimestampDiscrepancy currentTimestampDiscrepancy, boolean equalAllowed) {
        long currentTime;
        long senderTime;
        if (senderTimestampDiscrepancy == null) {
            senderTimestampDiscrepancy = TimestampDiscrepancy.NO_DISCREPANCY;
        }
        if (currentTimestampDiscrepancy == null) {
            currentTimestampDiscrepancy = TimestampDiscrepancy.NO_DISCREPANCY;
        }
        if (toChange.getOriginatingNode().equals(current.getOriginatingNode())) {
            senderTime = toChange.getTimestamp();
            currentTime = current.getTimestamp();
        } else {
            senderTime = senderTimestampDiscrepancy.getMinLocalTimestamp(toChange.getTimestamp());
            currentTime = currentTimestampDiscrepancy.getMaxLocalTimestamp(current.getTimestamp());
        }
        return equalAllowed ? senderTime > currentTime : senderTime > currentTime;
    }

    private TimestampDiscrepancy getTimestampDiscrepancy(String originatingNode, boolean allowStatusCheck) {
        TimestampDiscrepancy td = this.timestampService.getTimestampDiscrepancy(originatingNode, allowStatusCheck);
        return td == null ? TimestampDiscrepancy.NO_DISCREPANCY : td;
    }
}

