/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.deployers;

import java.util.HashSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.ha.framework.server.deployers.DefaultHAPartitionDependencyCreator;
import org.jboss.ha.framework.server.deployers.HAPartitionDependencyCreator;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public abstract class AbstractHAPartitionDependencyDeployer
extends AbstractDeployer {
    private HAPartitionDependencyCreator dependencyCreator;

    public AbstractHAPartitionDependencyDeployer() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addOutput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
    }

    public synchronized HAPartitionDependencyCreator getHaPartitionDependencyCreator() {
        if (this.dependencyCreator == null) {
            this.dependencyCreator = DefaultHAPartitionDependencyCreator.INSTANCE;
        }
        return this.dependencyCreator;
    }

    public synchronized void setHaPartitionDependencyCreator(HAPartitionDependencyCreator dependencyCreator) {
        this.dependencyCreator = dependencyCreator;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossEnterpriseBeansMetaData beans;
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME, JBossMetaData.class);
        if (metaData != null && this.accepts(metaData) && (beans = metaData.getEnterpriseBeans()) != null) {
            for (JBossEnterpriseBeanMetaData bmd : beans) {
                ClusterConfigMetaData ccmd = this.getClusteredBeanClusterConfig(bmd);
                if (ccmd == null) continue;
                this.addHAPartitionDependency(bmd, ccmd);
            }
        }
    }

    protected abstract boolean accepts(JBossMetaData var1);

    protected abstract void configureDeploymentStage();

    protected ClusterConfigMetaData getClusteredBeanClusterConfig(JBossEnterpriseBeanMetaData bmd) {
        JBossEntityBeanMetaData ebmd;
        if (bmd instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sbmd = (JBossSessionBeanMetaData)bmd;
            if (sbmd.isClustered()) {
                return sbmd.getClusterConfig();
            }
        } else if (bmd instanceof JBossEntityBeanMetaData && (ebmd = (JBossEntityBeanMetaData)bmd).isClustered()) {
            return ebmd.getClusterConfig();
        }
        return null;
    }

    private void addHAPartitionDependency(JBossEnterpriseBeanMetaData bmd, ClusterConfigMetaData ccmd) {
        String dependencyName = this.getHaPartitionDependencyCreator().getHAPartitionDependencyName(ccmd.getPartitionName());
        HashSet<String> depends = bmd.getDepends();
        if (depends == null) {
            depends = new HashSet<String>();
        }
        depends.add(dependencyName);
        bmd.setDepends(depends);
    }
}

