/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.deployment.scanner.URLDeploymentScanner;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterFileTransfer;
import org.jboss.ha.framework.server.ClusterFileTransferException;
import org.jboss.ha.framework.server.FarmMemberServiceMBean;
import org.jboss.system.server.ServerConfigLocator;

public class FarmMemberService
extends URLDeploymentScanner
implements FarmMemberServiceMBean {
    protected HAPartition mClusterPartition = null;
    private File mTempDirectory;
    private ClusterFileTransfer mFileTransfer;
    protected static final String SERVICE_NAME = "FarmMemberService";
    protected HashMap parentDUMap = new HashMap();
    protected ArrayList remotelyDeployed = new ArrayList();
    protected ArrayList remotelyUndeployed = new ArrayList();

    public String getPartitionName() {
        return this.mClusterPartition.getPartitionName();
    }

    public HAPartition getHAPartition() {
        return this.mClusterPartition;
    }

    public void setHAPartition(HAPartition clusterPartition) {
        if (this.getState() != 3 && this.getState() != 2) {
            this.mClusterPartition = clusterPartition;
        }
    }

    public void setFarmDeployDirectory(String urls) throws MalformedURLException {
        super.setURLs(urls);
    }

    public void setScannerName(String name) {
        this.log.warn((Object)"ScannerName does nothing");
    }

    public String getName() {
        return "Farm Member Service";
    }

    protected void createService() throws Exception {
        super.createService();
        ServerConfig lConfig = ServerConfigLocator.locate();
        this.mTempDirectory = lConfig.getServerTempDir();
        this.createUnexistingLocalDir();
    }

    protected void startService() throws Exception {
        try {
            if (this.mClusterPartition == null) {
                throw new IllegalStateException("HAPartition property must be set before starting FarmMember service");
            }
            this.log.debug((Object)"registerRPCHandler");
            this.mClusterPartition.registerRPCHandler(SERVICE_NAME, (Object)this);
            this.mFileTransfer = new ClusterFileTransfer(this.mClusterPartition, this.buildParentFolderMapping());
            ArrayList response = this.mClusterPartition.callMethodOnCoordinatorNode(SERVICE_NAME, "farmDeployments", new Object[0], new Class[0], true);
            this.log.debug((Object)("Found " + response.size() + " farmDeployments responses"));
            for (int i = 0; i < response.size(); ++i) {
                Object map = response.get(i);
                if (map == null || !(map instanceof HashMap)) continue;
                HashMap farmed = (HashMap)map;
                this.pullNewDeployments(this.mClusterPartition, farmed);
            }
            this.scannerThread.doScan();
            this.scannerThread.setEnabled(this.isScanEnabled());
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pullNewDeployments(HAPartition partition, HashMap farmed) {
        this.log.info((Object)"**** pullNewDeployments ****");
        for (String depName : farmed.keySet()) {
            Date theLast;
            URLDeploymentScanner.DeployedURL du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(depName);
            Date last = (Date)farmed.get(depName);
            if (du != null && !(theLast = new Date(du.getFile().lastModified())).before(last)) continue;
            String parentName = depName.substring(0, depName.indexOf(47));
            File destFile = new File(depName);
            try {
                this.mFileTransfer.pull(destFile, parentName);
                ArrayList arrayList = this.remotelyDeployed;
                synchronized (arrayList) {
                    this.remotelyDeployed.add(destFile.getName());
                }
            }
            catch (ClusterFileTransferException e) {
                this.logException(e);
            }
        }
    }

    private Map buildParentFolderMapping() {
        HashMap<String, File> map = new HashMap<String, File>();
        URL[] urls = this.urlList.toArray(new URL[0]);
        for (int i = 0; i < this.urlList.size(); ++i) {
            File file;
            if (!urls[i].getProtocol().equals("file") || !(file = new File(urls[i].getFile())).isDirectory()) continue;
            map.put(file.getName(), file);
        }
        return map;
    }

    protected File findParent(String parentName) {
        URL[] urls = this.urlList.toArray(new URL[0]);
        for (int i = 0; i < this.urlList.size(); ++i) {
            File file;
            if (!urls[i].getProtocol().equals("file") || !(file = new File(urls[i].getFile())).isDirectory() || !file.getName().equals(parentName)) continue;
            return file;
        }
        return null;
    }

    public HashMap farmDeployments() {
        this.log.debug((Object)("farmDeployments request, parentDUMap.size=" + this.parentDUMap.size()));
        Iterator it = this.parentDUMap.keySet().iterator();
        HashMap<String, Date> farmed = new HashMap<String, Date>();
        while (it.hasNext()) {
            String key = (String)it.next();
            URLDeploymentScanner.DeployedURL du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(key);
            farmed.put(key, new Date(du.getFile().lastModified()));
        }
        return farmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void farmDeploy(String parentName, File destFile, Date date) {
        block14: {
            try {
                Cloneable lastChanged;
                File parent = this.findParent(parentName);
                if (parent == null) {
                    this.log.info((Object)("Could not find parent: " + parentName + " for deployment: " + destFile + ", data: " + date));
                    return;
                }
                String fullName = parentName + "/" + destFile.getName();
                URLDeploymentScanner.DeployedURL du = null;
                HashMap hashMap = this.parentDUMap;
                synchronized (hashMap) {
                    du = (URLDeploymentScanner.DeployedURL)this.parentDUMap.get(fullName);
                }
                boolean deployIt = false;
                if (du == null) {
                    deployIt = true;
                } else {
                    lastChanged = new Date(du.getFile().lastModified());
                    deployIt = lastChanged.before(date);
                }
                if (deployIt) {
                    lastChanged = this.remotelyDeployed;
                    synchronized (lastChanged) {
                        this.remotelyDeployed.add(fullName);
                    }
                    this.log.info((Object)("farmDeployment(), deploy locally: " + fullName));
                    File tempFile = new File(this.mTempDirectory, destFile.getName());
                    File lFarmFile = new File(parent, destFile.getName());
                    if (lFarmFile.exists() && !lFarmFile.delete()) {
                        this.log.info((Object)("could not delete target file for farm deployment " + lFarmFile.getName()));
                    }
                    tempFile.setLastModified(date.getTime());
                    if (!ClusterFileTransfer.localMove(tempFile, lFarmFile)) {
                        this.log.info((Object)("Could not move " + tempFile + " to " + lFarmFile));
                    }
                    break block14;
                }
                this.log.info((Object)(fullName + " is already deployed by farm service on this node"));
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void farmUndeploy(String parentName, String fileName) {
        block8: {
            try {
                this.log.info((Object)("doUndeployment(), File: " + parentName + "/" + fileName));
                File parent = this.findParent(parentName);
                if (parent == null) {
                    this.log.info((Object)("Could not find parent: " + parentName + " for undeployment: " + fileName));
                    return;
                }
                File deployed = new File(parent, fileName);
                if (!deployed.exists()) break block8;
                ArrayList arrayList = this.remotelyUndeployed;
                synchronized (arrayList) {
                    String fullName = parentName + "/" + fileName;
                    this.remotelyUndeployed.add(fullName);
                }
                if (deployed.delete()) {
                    this.log.info((Object)("farmUndeployment(), removed file " + deployed));
                } else {
                    this.log.info((Object)("farmUndeployment(), could not remove file " + deployed));
                }
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(URLDeploymentScanner.DeployedURL du) {
        super.deploy(du);
        File file = du.getFile();
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        String fullName = parent.getName() + "/" + file.getName();
        HashMap hashMap = this.parentDUMap;
        synchronized (hashMap) {
            this.parentDUMap.put(fullName, du);
        }
        try {
            boolean consequenceOfRemoteCall = false;
            ArrayList arrayList = this.remotelyDeployed;
            synchronized (arrayList) {
                consequenceOfRemoteCall = this.remotelyDeployed.remove(fullName);
            }
            if (this.getState() == 2) {
                return;
            }
            if (!consequenceOfRemoteCall) {
                Date fileDate = new Date(file.lastModified());
                this.mFileTransfer.push(file, parent.getName(), true);
                this.mClusterPartition.callMethodOnCluster(SERVICE_NAME, "farmDeploy", new Object[]{parent.getName(), file, fileDate}, new Class[]{String.class, File.class, Date.class}, true);
            }
        }
        catch (ClusterFileTransferException e) {
            this.logException(e);
        }
        catch (Exception ex) {
            this.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(URLDeploymentScanner.DeployedURL du) {
        File file = du.getFile();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        String fileName = file.getName();
        super.undeploy(du);
        String fullName = parent.getName() + "/" + file.getName();
        HashMap hashMap = this.parentDUMap;
        synchronized (hashMap) {
            this.parentDUMap.remove(fullName);
        }
        if (this.getState() == 1) {
            return;
        }
        try {
            boolean consequenceOfRemoteCall = false;
            ArrayList arrayList = this.remotelyUndeployed;
            synchronized (arrayList) {
                consequenceOfRemoteCall = this.remotelyUndeployed.remove(fullName);
            }
            if (!consequenceOfRemoteCall) {
                this.mClusterPartition.callMethodOnCluster(SERVICE_NAME, "farmUndeploy", new Object[]{parentName, fileName}, new Class[]{String.class, String.class}, true);
            }
        }
        catch (Exception ex) {
            this.logException(ex);
        }
    }

    private void logException(Throwable e) {
        if (e instanceof RuntimeErrorException) {
            e = ((RuntimeErrorException)e).getTargetError();
        } else if (e instanceof RuntimeMBeanException) {
            e = ((RuntimeMBeanException)e).getTargetException();
        } else if (e instanceof RuntimeOperationsException) {
            e = ((RuntimeOperationsException)e).getTargetException();
        } else if (e instanceof MBeanException) {
            e = ((MBeanException)e).getTargetException();
        } else if (e instanceof ReflectionException) {
            e = ((ReflectionException)e).getTargetException();
        }
        this.log.error((Object)e);
    }

    protected void createUnexistingLocalDir() {
        if (this.urlList != null) {
            Iterator iter = this.urlList.iterator();
            while (iter.hasNext()) {
                URL url = null;
                try {
                    File targetDir;
                    url = (URL)iter.next();
                    if (!url.getProtocol().equals("file") || (targetDir = new File(url.getFile())).exists()) continue;
                    targetDir.mkdirs();
                }
                catch (Exception e) {
                    this.log.info((Object)("Problem while creating a farm directory: " + url), (Throwable)e);
                }
            }
        }
    }
}

