/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui.methods;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.ui.methods.JavaNewMethodCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Extendable;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class JavaNewMethodCommandImpl
extends AbstractProjectCommand
implements JavaNewMethodCommand {
    @Inject
    @WithAttributes(label="Target Class", description="The class where the method will be created", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Named", description="The name of the method created", required=true)
    private UIInput<String> methodName;
    @Inject
    @WithAttributes(label="Return", description="The return type of the method created", type="org.jboss.forge.inputType.JAVA_CLASS_PICKER", required=true, defaultValue="String")
    private UIInput<String> returnType;
    @Inject
    @WithAttributes(label="Parameters", description="Parameters of the method created", required=false)
    private UIInput<String> parameters;
    @Inject
    @WithAttributes(label="Access Type", description="The access type", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<Visibility> accessType;
    @Inject
    private ProjectOperations projectOperations;
    @Inject
    ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: New Method").description("Generates methods for the given Java class").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupTargetClass(builder.getUIContext());
        this.setupAccessType();
        builder.add(this.targetClass).add(this.returnType).add(this.parameters).add(this.accessType).add(this.methodName);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        MethodHolderSource methodHolder;
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        JavaSource targetclass = (JavaSource)javaResource.getJavaType();
        String name = (String)this.methodName.getValue();
        String returntype = (String)this.returnType.getValue();
        String parameterString = (String)this.parameters.getValue();
        Visibility visibility = (Visibility)this.accessType.getValue();
        LinkedHashMap<String, String> parametersMap = new LinkedHashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)parameterString)) {
            String[] parametersArray;
            for (String parameter : parametersArray = Strings.split((String)parameterString, (String)",")) {
                parameter = parameter.trim();
                String[] x = parameter.split(" ");
                parametersMap.put(x[1], x[0]);
            }
        }
        Object[] paramtypes = parametersMap.values().toArray();
        String[] parameterTypes = (String[])Arrays.copyOf(paramtypes, paramtypes.length, String[].class);
        MethodSource<JavaClassSource> superClassMethod = null;
        if (targetclass instanceof Extendable) {
            superClassMethod = this.inspectSuperClasses(context, ((Extendable)targetclass).getSuperType(), name, parameterTypes);
        }
        if (superClassMethod != null && !superClassMethod.isPrivate()) {
            if (superClassMethod.isStatic()) {
                return Results.fail((String)"Method was already present and was static in the super class");
            }
            if (superClassMethod.isFinal() && !superClassMethod.isPrivate()) {
                return Results.fail((String)"Method was already present and was final in the super class");
            }
            if (!superClassMethod.getReturnType().toString().equals(returntype)) {
                return Results.fail((String)"Method was already present and had a different return type in the super class");
            }
            if (superClassMethod.getVisibility().compareTo((Enum)visibility) < 0) {
                return Results.fail((String)"Method was already present and had higher access in the super class");
            }
        }
        if ((methodHolder = (MethodHolderSource)targetclass).getMethod(name, parameterTypes) != null) {
            return Results.fail((String)"Method was already present in the target class");
        }
        MethodSource newMethod = methodHolder.addMethod();
        newMethod.setName(name);
        newMethod.setReturnType(returntype);
        newMethod.setVisibility(visibility);
        if (!Strings.isNullOrEmpty((String)parameterString)) {
            for (Map.Entry entry : parametersMap.entrySet()) {
                newMethod.addParameter((String)entry.getValue(), (String)entry.getKey());
            }
        }
        if (!targetclass.isInterface()) {
            newMethod.setBody("throw new UnsupportedOperationException(\"Not supported yet.\");");
        }
        if (superClassMethod != null && !superClassMethod.isPrivate()) {
            newMethod.addAnnotation("Override");
        }
        this.setCurrentWorkingResource(context, targetclass);
        return Results.success((String)"Method was generated successfully");
    }

    private MethodSource<JavaClassSource> inspectSuperClasses(UIExecutionContext context, String type, String name, String[] paramTypes) {
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaSource<?> clazz = JavaNewMethodCommandImpl.sourceForName(project, type);
        if (clazz instanceof JavaClass) {
            JavaClassSource source = (JavaClassSource)Roaster.parse(JavaClassSource.class, (String)clazz.toString());
            MethodSource superClassMethod = source.getMethod(name, paramTypes);
            if (superClassMethod != null) {
                return superClassMethod;
            }
            if (!source.getSuperType().equals("java.lang.Object")) {
                return this.inspectSuperClasses(context, source.getSuperType(), name, paramTypes);
            }
        }
        return null;
    }

    private static JavaSource<?> sourceForName(Project project, String type) {
        try {
            JavaSourceFacet javaSourceFact = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            return (JavaSource)javaSourceFact.getJavaResource(type).getJavaType();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ResourceException e) {
            return null;
        }
    }

    private void setupTargetClass(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        ArrayList entities = new ArrayList();
        entities.addAll(this.projectOperations.getProjectClasses(project));
        entities.addAll(this.projectOperations.getProjectInterfaces(project));
        this.targetClass.setValueChoices(entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetClass.setDefaultValue(entities.get(idx));
        }
    }

    private void setCurrentWorkingResource(UIExecutionContext context, JavaSource<?> javaClass) throws FileNotFoundException {
        Project selectedProject = this.getSelectedProject((UIContextProvider)context);
        if (selectedProject != null) {
            JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
            facet.saveJavaSource(javaClass);
        }
        context.getUIContext().setSelection(javaClass);
    }

    private void setupAccessType() {
        this.accessType.setItemLabelConverter((Converter)new Converter<Visibility, String>(){

            public String convert(Visibility source) {
                if (source == null) {
                    return null;
                }
                if (source == Visibility.PACKAGE_PRIVATE) {
                    return "default";
                }
                return source.toString();
            }
        });
        this.accessType.setDefaultValue((Object)Visibility.PRIVATE);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

