/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui.annotations;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaFieldResource;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResource;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.ui.annotations.JavaAddAnnotationCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.util.ResourceUtil;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Parameter;
import org.jboss.forge.roaster.model.ValuePair;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@FacetConstraint(value={JavaSourceFacet.class})
public class JavaAddAnnotationCommandImpl
extends AbstractProjectCommand
implements JavaAddAnnotationCommand {
    @Inject
    @WithAttributes(label="Target Class", description="The class where the annotation will be added", required=true, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaResource> targetClass;
    @Inject
    @WithAttributes(label="Annotation", description="The annotation which will be added", required=true, type="org.jboss.forge.inputType.DEFAULT")
    private UIInput<String> annotation;
    @Inject
    @WithAttributes(label="Target Property", description="The property where the annotation will be added", required=false, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaFieldResource> onProperty;
    @Inject
    @WithAttributes(label="Target Method", description="The method where the annotation will be added", required=false, type="org.jboss.forge.inputType.DROPDOWN")
    private UISelectOne<JavaMethodResource> onMethod;
    @Inject
    private ProjectOperations projectOperations;
    @Inject
    private ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: Add Annotation").description("Add annotation to class, property or method.").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(final UIBuilder builder) {
        this.setupTargetClass(builder.getUIContext());
        this.onProperty.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (JavaAddAnnotationCommandImpl.this.onMethod.getValue() != null || JavaAddAnnotationCommandImpl.this.onProperty.getValue() != null) {
                    return false;
                }
                JavaResource javaResource = (JavaResource)JavaAddAnnotationCommandImpl.this.targetClass.getValue();
                if (javaResource != null) {
                    return ResourceUtil.filterByType(JavaFieldResource.class, (Collection)javaResource.listResources()).size() > 0;
                }
                return false;
            }
        });
        this.onMethod.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (JavaAddAnnotationCommandImpl.this.onMethod.getValue() != null || JavaAddAnnotationCommandImpl.this.onProperty.getValue() != null) {
                    return false;
                }
                JavaResource javaResource = (JavaResource)JavaAddAnnotationCommandImpl.this.targetClass.getValue();
                if (javaResource != null) {
                    return ResourceUtil.filterByType(JavaMethodResource.class, (Collection)javaResource.listResources()).size() > 0;
                }
                return false;
            }
        });
        this.onProperty.setValueChoices((Callable)new Callable<Iterable<JavaFieldResource>>(){

            @Override
            public Iterable<JavaFieldResource> call() {
                JavaResource javaResource = (JavaResource)JavaAddAnnotationCommandImpl.this.targetClass.getValue();
                if (javaResource != null) {
                    return ResourceUtil.filterByType(JavaFieldResource.class, (Collection)javaResource.listResources());
                }
                return Collections.emptyList();
            }
        });
        this.onMethod.setValueChoices((Callable)new Callable<Iterable<JavaMethodResource>>(){

            @Override
            public Iterable<JavaMethodResource> call() {
                JavaResource javaResource = (JavaResource)JavaAddAnnotationCommandImpl.this.targetClass.getValue();
                if (javaResource != null) {
                    return ResourceUtil.filterByType(JavaMethodResource.class, (Collection)javaResource.listResources());
                }
                return Collections.emptyList();
            }
        });
        this.onProperty.setItemLabelConverter((Converter)new Converter<JavaFieldResource, String>(){

            public String convert(JavaFieldResource source) {
                return source == null ? null : ((Field)source.getUnderlyingResourceObject()).getName();
            }
        });
        this.onMethod.setItemLabelConverter((Converter)new Converter<JavaMethodResource, String>(){

            public String convert(JavaMethodResource source) {
                return source == null ? null : ((Method)source.getUnderlyingResourceObject()).getName();
            }
        });
        this.annotation.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                Project project = JavaAddAnnotationCommandImpl.this.getSelectedProject(builder.getUIContext());
                List javaClasses = JavaAddAnnotationCommandImpl.this.projectOperations.getProjectAnnotations(project);
                ArrayList<String> projectAnnotations = new ArrayList<String>();
                for (JavaResource javaResource : javaClasses) {
                    try {
                        projectAnnotations.add(javaResource.getJavaType().getCanonicalName());
                    }
                    catch (FileNotFoundException | ResourceException throwable) {}
                }
                return projectAnnotations;
            }
        });
        builder.add(this.targetClass).add(this.annotation).add(this.onProperty).add(this.onMethod);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result;
        JavaClassSource javaSource = (JavaClassSource)((JavaResource)this.targetClass.getValue()).getJavaType();
        if (this.onProperty.hasValue()) {
            String propertyName = ((Field)((JavaFieldResource)this.onProperty.getValue()).getUnderlyingResourceObject()).getName();
            FieldSource field = javaSource.getField(propertyName);
            this.addAnnotationToSource((AnnotationTargetSource)field, (String)this.annotation.getValue());
            result = Results.success((String)("Annotation \"" + (String)this.annotation.getValue() + "\" was successfully added to \"" + propertyName + "\" property declaration."));
        } else if (this.onMethod.hasValue()) {
            List parameters = ((Method)((JavaMethodResource)this.onMethod.getValue()).getUnderlyingResourceObject()).getParameters();
            String[] stringParametersArray = new String[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                stringParametersArray[i] = ((Parameter)parameters.get(i)).getType().getName();
            }
            String methodName = ((Method)((JavaMethodResource)this.onMethod.getValue()).getUnderlyingResourceObject()).getName();
            MethodSource method = javaSource.getMethod(methodName, stringParametersArray);
            this.addAnnotationToSource((AnnotationTargetSource)method, (String)this.annotation.getValue());
            result = Results.success((String)("Annotation \"" + (String)this.annotation.getValue() + "\" was successfully added to the \"" + methodName + "\" method declaration."));
        } else {
            this.addAnnotationToSource((AnnotationTargetSource)javaSource, (String)this.annotation.getValue());
            result = Results.success((String)("Annotation \"" + (String)this.annotation.getValue() + "\" was successfully added to the class declaration."));
        }
        ((JavaSourceFacet)this.getSelectedProject((UIContextProvider)context).getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)javaSource);
        return result;
    }

    private void addAnnotationToSource(AnnotationTargetSource targetSource, String annotationStr) {
        AnnotationSource annotationSource;
        String annotationClassName = this.getAnnotationClassNameFromString(annotationStr);
        AnnotationSource annotationToRemove = targetSource.getAnnotation(annotationClassName);
        if (annotationToRemove != null) {
            targetSource.removeAnnotation((Annotation)annotationToRemove);
        }
        try {
            annotationSource = targetSource.addAnnotation(annotationClassName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Annotation with name \"" + annotationClassName + "\" couldn't be added. Are you sure it's correct?");
        }
        this.populateAnnotationFromString((AnnotationSource<JavaClassSource>)annotationSource, (String)this.annotation.getValue());
    }

    private void populateAnnotationFromString(AnnotationSource<JavaClassSource> annotationSource, String str) {
        JavaClass parsedClass;
        String stub = "@" + str + " public class Stub { }";
        try {
            parsedClass = (JavaClass)Roaster.parse(JavaClass.class, (String)stub);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't parse annotation \"" + str + "\". Are you sure it's correct?");
        }
        if (parsedClass.getAnnotations().size() == 0) {
            throw new IllegalArgumentException("Can't parse annotation \"" + str + "\". Are you sure it's correct?");
        }
        List valuePairs = ((Annotation)parsedClass.getAnnotations().get(0)).getValues();
        for (ValuePair valuePair : valuePairs) {
            if ("$missing$".equals(valuePair.getLiteralValue())) {
                throw new IllegalArgumentException("Parameter \"" + valuePair.getName() + "\" is missing or is incomplete.");
            }
            annotationSource.setLiteralValue(valuePair.getName(), valuePair.getLiteralValue());
        }
    }

    private String getAnnotationClassNameFromString(String annotationString) {
        int leftParenthesisIndex = annotationString.indexOf(40);
        if (leftParenthesisIndex > -1) {
            return annotationString.substring(0, leftParenthesisIndex);
        }
        return annotationString;
    }

    private void setupTargetClass(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        List entities = this.projectOperations.getProjectClasses(project);
        this.targetClass.setValueChoices((Iterable)entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx != -1) {
            this.targetClass.setDefaultValue(entities.get(idx));
        }
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

