/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitSetupCommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class GitSetupCommandImpl
extends AbstractGitCommand
implements GitSetupCommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private GitFacet facet;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GIT: Setup").description("Prepares the project for functioning in GIT context");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)this.facet)) {
            return Results.success((String)"GIT has been installed.");
        }
        return Results.fail((String)"Could not install GIT.");
    }

    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && !this.getSelectedProject(context).getRootDirectory().getChildDirectory(".git").exists();
    }
}

