/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.gitignore.GitIgnoreConfig;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreSetupCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={GitFacet.class})
public class GitIgnoreSetupCommandImpl
extends AbstractGitCommand
implements GitIgnoreSetupCommand {
    @Inject
    @WithAttributes(label="Checkout directory", description="Where should the gitignore template repository be installed at?")
    private UIInput<FileResource<?>> templateRepoDir;
    @Inject
    @WithAttributes(label="Repository", description="Do you want to provide a different repository location for gitignore templates?")
    private UIInput<String> repository;
    @Inject
    private GitIgnoreConfig config;
    @Inject
    private ResourceFactory factory;
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private GitIgnoreFacet facet;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GITIGNORE: Setup").description("Create .gitignore files based on template files from https://github.com/github/gitignore.git.");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.templateRepoDir.setDefaultValue(this.getDefaultCheckoutDir());
        this.repository.setDefaultValue((Object)this.config.defaultRemoteRepository());
        builder.add(this.templateRepoDir).add(this.repository);
    }

    private FileResource<?> getDefaultCheckoutDir() {
        return (FileResource)this.factory.create((Object)this.config.defaultLocalRepository());
    }

    public void validate(UIValidationContext context) {
        FileResource checkoutDir = (FileResource)this.templateRepoDir.getValue();
        if (checkoutDir.exists()) {
            if (!checkoutDir.isDirectory()) {
                context.addValidationError(this.templateRepoDir, "File " + checkoutDir + " is not a directory.");
            }
            if (!checkoutDir.listResources().isEmpty()) {
                context.addValidationError(this.templateRepoDir, "Directory " + checkoutDir + " is not empty");
            }
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        FileResource checkoutDir = (FileResource)this.templateRepoDir.getValue();
        if (!checkoutDir.exists()) {
            checkoutDir.mkdirs();
        }
        this.config.setLocalRepository(checkoutDir.getFullyQualifiedName());
        this.config.setRemoteRepository((String)this.repository.getValue());
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)this.facet)) {
            return Results.success((String)"GITIGNORE has been installed.");
        }
        return Results.fail((String)"Could not install GITIGNORE.");
    }
}

