/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.gitignore.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.git.gitignore.GitIgnoreEntry;
import org.jboss.forge.addon.git.gitignore.resources.GitIgnorePatternResource;
import org.jboss.forge.addon.git.gitignore.resources.GitIgnoreResource;
import org.jboss.forge.addon.resource.AbstractFileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;

public class GitIgnoreResourceImpl
extends AbstractFileResource<GitIgnoreResource>
implements GitIgnoreResource {
    public GitIgnoreResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public GitIgnoreResource createFrom(File file) {
        return new GitIgnoreResourceImpl(this.getResourceFactory(), file);
    }

    protected List<Resource<?>> doListResources() {
        ArrayList patterns = new ArrayList();
        for (GitIgnoreEntry entry : this.getEntries()) {
            if (!entry.isPattern()) continue;
            patterns.add((Resource<?>)new GitIgnorePatternResource(this.getResourceFactory(), (Resource<?>)this, entry.getContent()));
        }
        return patterns;
    }

    public void addPattern(String pattern) {
        GitIgnoreEntry entry;
        List<GitIgnoreEntry> entries = this.getEntries();
        if (!entries.contains(entry = new GitIgnoreEntry(pattern))) {
            entries.add(entry);
            this.storeEntries(entries);
        }
    }

    public void addPatterns(String[] newPatterns) {
        List<GitIgnoreEntry> entries = this.getEntries();
        boolean modified = false;
        for (String pattern : newPatterns) {
            GitIgnoreEntry entry = new GitIgnoreEntry(pattern);
            if (!entries.contains(entry)) continue;
            entries.add(entry);
            modified = true;
        }
        if (modified) {
            this.storeEntries(entries);
        }
    }

    public void removePattern(String pattern) {
        GitIgnoreEntry entry;
        List<GitIgnoreEntry> entries = this.getEntries();
        if (entries.contains(entry = new GitIgnoreEntry(pattern))) {
            entries.remove(entry);
            this.storeEntries(entries);
        }
    }

    public List<String> getPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (GitIgnoreEntry entry : this.getEntries()) {
            if (!entry.isPattern()) continue;
            patterns.add(entry.toString());
        }
        return patterns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GitIgnoreEntry> getEntries() {
        ArrayList<GitIgnoreEntry> lines = new ArrayList<GitIgnoreEntry>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getResourceInputStream()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(new GitIgnoreEntry(line));
            }
            ArrayList<GitIgnoreEntry> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading .gitignore patterns", e);
        }
    }

    protected void storeEntries(List<GitIgnoreEntry> entries) {
        StringBuilder contents = new StringBuilder();
        for (GitIgnoreEntry entry : entries) {
            contents.append(entry.toString()).append("\n");
        }
        this.setContents(contents.toString());
    }
}

