/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.gitignore;

import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.ConfigurationFactory;

public class GitIgnoreConfig {
    @Inject
    private ConfigurationFactory configFactory;

    public String defaultRemoteRepository() {
        return "https://github.com/github/gitignore.git";
    }

    public String remoteRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey("gitignore.plugin.repo")) {
            return user.getString("gitignore.plugin.repo");
        }
        return this.defaultRemoteRepository();
    }

    public void setRemoteRepository(String repoUrl) {
        this.userConfig().setProperty("gitignore.plugin.repo", (Object)repoUrl);
    }

    public File defaultLocalRepository() {
        return new File(System.getProperty("user.home") + File.separator + ".gitignore_boilerplate");
    }

    public File localRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey("gitignore.plugin.clone")) {
            return new File(user.getString("gitignore.plugin.clone"));
        }
        return this.defaultLocalRepository();
    }

    public void setLocalRepository(String location) {
        this.userConfig().setProperty("gitignore.plugin.clone", (Object)location);
    }

    private Configuration userConfig() {
        return this.configFactory.getUserConfiguration();
    }
}

