/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.facet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.GitUtils;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.gitignore.GitIgnoreConfig;
import org.jboss.forge.addon.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.furnace.util.Streams;

@FacetConstraint(value={GitFacet.class})
public class GitIgnoreFacetImpl
extends AbstractFacet<Project>
implements GitIgnoreFacet {
    @Inject
    private GitIgnoreConfig config;
    @Inject
    private GitUtils gitUtils;
    @Inject
    private ResourceFactory factory;

    public boolean install() {
        try {
            DirectoryResource cloneDir = this.cloneDir();
            String repo = this.config.remoteRepository();
            Git git = this.gitUtils.clone(cloneDir, repo);
            this.gitUtils.close(git);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isInstalled() {
        File clone = this.config.localRepository();
        Resource cloneDir = this.factory.create((Object)clone);
        return cloneDir.exists() && cloneDir.getChild(".git").exists();
    }

    public List<GitIgnoreTemplateGroup> list() {
        ArrayList<GitIgnoreTemplateGroup> result = new ArrayList<GitIgnoreTemplateGroup>(2);
        DirectoryResource languages = this.cloneDir();
        result.add(new GitIgnoreTemplateGroup("Languages", this.listGitignores(languages)));
        result.add(new GitIgnoreTemplateGroup("Globals", this.listGitignores(languages.getChildDirectory("Global"))));
        return result;
    }

    public String contentOf(String template) {
        DirectoryResource[] candidates;
        for (DirectoryResource dir : candidates = new DirectoryResource[]{this.cloneDir(), this.cloneDir().getChildDirectory("Global")}) {
            if (!this.listGitignores(dir).contains(template)) continue;
            FileResource file = (FileResource)dir.getChildOfType(FileResource.class, template + ".gitignore");
            return Streams.toString((InputStream)file.getResourceInputStream());
        }
        return "";
    }

    public void update() throws IOException, GitAPIException {
        Git git = this.gitUtils.git(this.cloneDir());
        this.gitUtils.pull(git, 10000);
        this.gitUtils.close(git);
    }

    private List<String> listGitignores(DirectoryResource dir) {
        LinkedList<String> result = new LinkedList<String>();
        ResourceFilter filter = new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource.getName().endsWith(".gitignore");
            }
        };
        for (Resource resource : dir.listResources(filter)) {
            String name = resource.getName();
            String cut = name.substring(0, name.indexOf(".gitignore"));
            result.add(cut);
        }
        return result;
    }

    private DirectoryResource cloneDir() {
        return (DirectoryResource)this.factory.create(DirectoryResource.class, (Object)this.config.localRepository());
    }
}

