/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.facet;

import java.io.File;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.git.GitUtils;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;

public class GitFacetImpl
extends AbstractFacet<Project>
implements GitFacet {
    @Inject
    private GitUtils gitUtils;

    public boolean install() {
        Project project = (Project)this.getFaceted();
        DirectoryResource rootDirectory = project.getRootDirectory();
        FileResource gitDir = (FileResource)rootDirectory.getChildDirectory(".git").reify(FileResource.class);
        if (!gitDir.exists()) {
            InitCommand init = Git.init();
            init.setDirectory((File)rootDirectory.getUnderlyingResourceObject());
            try {
                this.gitUtils.close(init.call());
            }
            catch (GitAPIException e) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean isInstalled() {
        return ((Project)this.getFaceted()).getRootDirectory().getChildDirectory(".git").exists();
    }
}

