/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.bpaf;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.bpaf.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"eventDetails", "dataElement"})
@XmlRootElement(name="Event")
@Entity
@Table(name="BPAF_EVENT")
public class Event {
    @XmlElement(name="EventDetails", required=true)
    protected EventDetails eventDetails;
    @XmlElement(name="DataElement")
    protected List<Tuple> dataElement;
    @XmlAttribute(name="EventID", required=true)
    protected long eventID;
    @XmlAttribute(name="ServerID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String serverID;
    @XmlAttribute(name="ProcessDefinitionID", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String processDefinitionID;
    @XmlAttribute(name="ProcessInstanceID", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    @Column(name="PROCESS_INSTANCE_ID")
    protected String processInstanceID;
    @XmlAttribute(name="ProcessName")
    @Column(name="PROCESS_NAME")
    protected String processName;
    @XmlAttribute(name="ActivityDefinitionID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    @Column(name="ACTIVITY_DEFINITION_ID")
    protected String activityDefinitionID;
    @XmlAttribute(name="ActivityInstanceID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    @Column(name="ACTIVITY_IINSTANCE_ID")
    protected String activityInstanceID;
    @XmlAttribute(name="ActivityName")
    @Column(name="ACTIVITY_NAME")
    protected String activityName;
    @XmlAttribute(name="Timestamp", required=true)
    @XmlSchemaType(name="long")
    @Column(name="TIMESTAMP")
    protected long timestamp;

    public Event() {
    }

    public Event(boolean implicitTimestamp) {
        if (implicitTimestamp) {
            this.timestamp = System.currentTimeMillis();
        }
    }

    public EventDetails getEventDetails() {
        if (null == this.eventDetails) {
            this.eventDetails = new EventDetails();
        }
        return this.eventDetails;
    }

    public void setEventDetails(EventDetails value) {
        this.eventDetails = value;
    }

    @OneToMany(mappedBy="event", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public List<Tuple> getDataElement() {
        if (this.dataElement == null) {
            this.dataElement = new ArrayList<Tuple>();
        }
        return this.dataElement;
    }

    public void addData(Tuple tuple) {
        tuple.setEvent(this);
        this.getDataElement().add(tuple);
    }

    public void setDataElement(List<Tuple> data) {
        this.dataElement = data;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="EID")
    public long getEventID() {
        return this.eventID;
    }

    public void setEventID(long value) {
        this.eventID = value;
    }

    @Basic(optional=true)
    @Column(name="SERVER_ID")
    public String getServerID() {
        return this.serverID;
    }

    public void setServerID(String value) {
        this.serverID = value;
    }

    @Basic
    @Column(name="PROCESS_DEFINITION_ID")
    public String getProcessDefinitionID() {
        return this.processDefinitionID;
    }

    public void setProcessDefinitionID(String value) {
        this.processDefinitionID = value;
    }

    @Basic
    @Column(name="PROCESS_INSTANCE_ID")
    public String getProcessInstanceID() {
        return this.processInstanceID;
    }

    public void setProcessInstanceID(String value) {
        this.processInstanceID = value;
    }

    @Basic(optional=true)
    @Column(name="PROCESS_NAME")
    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String value) {
        this.processName = value;
    }

    @Basic(optional=true)
    @Column(name="ACTIVITY_DEFINITION_ID")
    public String getActivityDefinitionID() {
        return this.activityDefinitionID;
    }

    public void setActivityDefinitionID(String value) {
        this.activityDefinitionID = value;
    }

    @Basic(optional=true)
    @Column(name="ACTIVITY_INSTANCE_ID")
    public String getActivityInstanceID() {
        return this.activityInstanceID;
    }

    public void setActivityInstanceID(String value) {
        this.activityInstanceID = value;
    }

    @Basic(optional=true)
    @Column(name="ACTIVITY_NAME")
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String value) {
        this.activityName = value;
    }

    @Column(name="TIMESTAMP")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long value) {
        this.timestamp = value;
    }

    public String toString() {
        return "Event{timestamp=" + this.timestamp + ", processDefinitionID='" + this.processDefinitionID + '\'' + ", processInstanceID='" + this.processInstanceID + '\'' + ", activityDefinitionID='" + this.activityDefinitionID + '\'' + ", eventDetails=" + this.eventDetails + '}';
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    @Embeddable
    public static class EventDetails {
        @XmlAttribute(name="CurrentState", required=true)
        protected State currentState;
        @XmlAttribute(name="PreviousState")
        protected State previousState;

        @Basic
        @Enumerated(value=EnumType.STRING)
        @Column(name="CURRENT_STATE")
        public State getCurrentState() {
            return this.currentState;
        }

        public void setCurrentState(State currentState) {
            this.currentState = currentState;
        }

        @Basic(optional=true)
        @Enumerated(value=EnumType.STRING)
        @Column(name="PREVIOUS_STATE")
        public State getPreviousState() {
            return this.previousState;
        }

        public void setPreviousState(State previousState) {
            this.previousState = previousState;
        }

        public String toString() {
            return "EventDetails{currentState=" + (Object)((Object)this.currentState) + '}';
        }
    }
}

