/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.util.Collections;
import java.util.Set;

public class EJBMethodSecurityAttribute {
    public static final EJBMethodSecurityAttribute PERMIT_ALL = new EJBMethodSecurityAttribute(true, false, Collections.<String>emptySet());
    public static final EJBMethodSecurityAttribute DENY_ALL = new EJBMethodSecurityAttribute(false, true, Collections.<String>emptySet());
    public static final EJBMethodSecurityAttribute NONE = new EJBMethodSecurityAttribute(false, false, Collections.<String>emptySet());
    private final boolean permitAll;
    private final boolean denyAll;
    private final Set<String> rolesAllowed;

    private EJBMethodSecurityAttribute(boolean permitAll, boolean denyAll, Set<String> rolesAllowed) {
        if (rolesAllowed == null) {
            throw new NullPointerException("rolesAllowed");
        }
        this.permitAll = permitAll;
        this.denyAll = denyAll;
        this.rolesAllowed = rolesAllowed;
    }

    public static EJBMethodSecurityAttribute none() {
        return NONE;
    }

    public static EJBMethodSecurityAttribute permitAll() {
        return PERMIT_ALL;
    }

    public static EJBMethodSecurityAttribute denyAll() {
        return DENY_ALL;
    }

    public static EJBMethodSecurityAttribute rolesAllowed(Set<String> roles) {
        return new EJBMethodSecurityAttribute(false, false, roles);
    }

    public boolean isPermitAll() {
        return this.permitAll;
    }

    public boolean isDenyAll() {
        return this.denyAll;
    }

    public Set<String> getRolesAllowed() {
        return this.rolesAllowed;
    }
}

