/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.marshallers;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.core.marshallers.Marshaller;

public class URIParamMarshaller
implements Marshaller {
    @Override
    public void build(ClientRequest request, Object target) {
        URI uri = this.getUri(target);
        if (uri != null) {
            request.overrideUri(uri);
        }
    }

    private URI getUri(Object target) {
        try {
            if (target instanceof URI) {
                return (URI)target;
            }
            if (target instanceof URL) {
                return ((URL)target).toURI();
            }
            if (target instanceof String) {
                return new URI(target.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

