/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModClusterRemoveCustomMetric
implements OperationStepHandler,
DescriptionProvider {
    static final ModClusterRemoveCustomMetric INSTANCE = new ModClusterRemoveCustomMetric();

    public ModelNode getModelDescription(Locale locale) {
        return ModClusterSubsystemDescriptions.getRemoveCustomMetricDescription(locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode dynamicLoadProvider = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("dynamic-load-provider");
        String classname = null;
        if (dynamicLoadProvider.isDefined()) {
            List list = operation.asPropertyList();
            for (Property prop : list) {
                if (!prop.getName().equals("class")) continue;
                classname = prop.getValue().asString();
                break;
            }
            if (classname != null) {
                this.removeMetric(dynamicLoadProvider, classname);
            }
        }
        if (!dynamicLoadProvider.get("load-metric").isDefined() && !dynamicLoadProvider.get("custom-load-metric").isDefined()) {
            context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().remove("dynamic-load-provider");
        }
        if (context.isNormalServer()) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (context.isNormalServer()) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    private void removeMetric(ModelNode dynamicLoadProvider, String classname) {
        List list = dynamicLoadProvider.get("custom-load-metric").asList();
        List newlist = Collections.emptyList();
        dynamicLoadProvider.get("custom-load-metric").set(newlist);
        for (ModelNode node : list) {
            if (node.get("class").asString().equals(classname)) continue;
            dynamicLoadProvider.get("custom-load-metric").add(node);
        }
        list = dynamicLoadProvider.get("custom-load-metric").asList();
        if (list.isEmpty()) {
            dynamicLoadProvider.remove("custom-load-metric");
        }
    }
}

