/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.modcluster.ModClusterAddCustomMetric;
import org.jboss.as.modcluster.ModClusterAddMetric;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterRemoveCustomMetric;
import org.jboss.as.modcluster.ModClusterRemoveMetric;
import org.jboss.as.modcluster.ModClusterSubsystemDescriptionProviders;
import org.jboss.as.modcluster.ZeroToNegativeOneParameterCorrector;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ModClusterConfigResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition ADVERTISE_SOCKET = SimpleAttributeDefinitionBuilder.create((String)"advertise-socket", (ModelType)ModelType.STRING, (boolean)true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PROXY_LIST = SimpleAttributeDefinitionBuilder.create((String)"proxy-list", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PROXY_URL = SimpleAttributeDefinitionBuilder.create((String)"proxy-url", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("/")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition ADVERTISE = SimpleAttributeDefinitionBuilder.create((String)"advertise", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition ADVERTISE_SECURITY_KEY = SimpleAttributeDefinitionBuilder.create((String)"advertise-security-key", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition EXCLUDED_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"excluded-contexts", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setDefaultValue(new ModelNode("ROOT,invoker,jbossws,juddi,console")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition AUTO_ENABLE_CONTEXTS = SimpleAttributeDefinitionBuilder.create((String)"auto-enable-contexts", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STOP_CONTEXT_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"stop-context-timeout", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition SOCKET_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"socket-timeout", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(20)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION = SimpleAttributeDefinitionBuilder.create((String)"sticky-session", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION_REMOVE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-remove", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition STICKY_SESSION_FORCE = SimpleAttributeDefinitionBuilder.create((String)"sticky-session-force", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition WORKER_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"worker-timeout", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition MAX_ATTEMPTS = SimpleAttributeDefinitionBuilder.create((String)"max-attempts", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition FLUSH_PACKETS = SimpleAttributeDefinitionBuilder.create((String)"flush-packets", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition FLUSH_WAIT = SimpleAttributeDefinitionBuilder.create((String)"flush-wait", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition PING = SimpleAttributeDefinitionBuilder.create((String)"ping", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(10)).setMeasurementUnit(MeasurementUnit.SECONDS).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition SMAX = SimpleAttributeDefinitionBuilder.create((String)"smax", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition TTL = SimpleAttributeDefinitionBuilder.create((String)"ttl", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition NODE_TIMEOUT = SimpleAttributeDefinitionBuilder.create((String)"node-timeout", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(-1)).setMeasurementUnit(MeasurementUnit.SECONDS).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true)).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition BALANCER = SimpleAttributeDefinitionBuilder.create((String)"balancer", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final SimpleAttributeDefinition DOMAIN = SimpleAttributeDefinitionBuilder.create((String)"domain", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADVERTISE_SOCKET, PROXY_LIST, PROXY_URL, ADVERTISE, ADVERTISE_SECURITY_KEY, EXCLUDED_CONTEXTS, AUTO_ENABLE_CONTEXTS, STOP_CONTEXT_TIMEOUT, SOCKET_TIMEOUT, STICKY_SESSION, STICKY_SESSION_REMOVE, STICKY_SESSION_FORCE, WORKER_TIMEOUT, MAX_ATTEMPTS, FLUSH_PACKETS, FLUSH_WAIT, PING, SMAX, TTL, NODE_TIMEOUT, BALANCER, DOMAIN};
    public static final Map<String, SimpleAttributeDefinition> ATTRIBUTES_BY_NAME;

    public ModClusterConfigResourceDefinition() {
        super(ModClusterExtension.configurationPath, ModClusterSubsystemDescriptionProviders.CONFIGURATION);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
        resourceRegistration.registerReadWriteAttribute("dynamic-load-provider", null, (OperationStepHandler)new WriteDynamicLoadProviderOperationHandler(), AttributeAccess.Storage.CONFIGURATION);
        resourceRegistration.registerReadWriteAttribute("simple-load-provider", null, (OperationStepHandler)new WriteSimpleLoadProviderOperationHandler(), AttributeAccess.Storage.CONFIGURATION);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        EnumSet<OperationEntry.Flag> runtimeOnlyFlags = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
        resourceRegistration.registerOperationHandler("add-metric", (OperationStepHandler)ModClusterAddMetric.INSTANCE, (DescriptionProvider)ModClusterAddMetric.INSTANCE, false, runtimeOnlyFlags);
        resourceRegistration.registerOperationHandler("add-custom-metric", (OperationStepHandler)ModClusterAddCustomMetric.INSTANCE, (DescriptionProvider)ModClusterAddCustomMetric.INSTANCE, false, runtimeOnlyFlags);
        resourceRegistration.registerOperationHandler("remove-metric", (OperationStepHandler)ModClusterRemoveMetric.INSTANCE, (DescriptionProvider)ModClusterRemoveMetric.INSTANCE, false, runtimeOnlyFlags);
        resourceRegistration.registerOperationHandler("remove-custom-metric", (OperationStepHandler)ModClusterRemoveCustomMetric.INSTANCE, (DescriptionProvider)ModClusterRemoveCustomMetric.INSTANCE, false, runtimeOnlyFlags);
    }

    static {
        HashMap<String, SimpleAttributeDefinition> attrs = new HashMap<String, SimpleAttributeDefinition>();
        for (AttributeDefinition attr : ATTRIBUTES) {
            attrs.put(attr.getName(), (SimpleAttributeDefinition)attr);
        }
        ATTRIBUTES_BY_NAME = Collections.unmodifiableMap(attrs);
    }

    public static class WriteSimpleLoadProviderOperationHandler
    implements OperationStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode factor = operation.get("factor");
            ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode currentValue = submodel.get("simple-load-provider").clone();
            if (!factor.isDefined()) {
                factor = currentValue.get("history");
            }
            submodel.get("factor").set(factor);
            submodel.get("simple-load-provider").get("factor").set(factor);
            context.completeStep();
        }
    }

    public static class WriteDynamicLoadProviderOperationHandler
    implements OperationStepHandler {
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode history = operation.get("history");
            ModelNode decay = operation.get("decay");
            ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode currentValue = submodel.get("dynamic-load-provider").clone();
            if (!history.isDefined()) {
                history = currentValue.get("history");
            }
            submodel.get("history").set(history);
            if (!decay.isDefined()) {
                decay = currentValue.get("decay");
            }
            submodel.get("decay").set(decay);
            submodel.get("dynamic-load-provider").get("history").set(history);
            submodel.get("dynamic-load-provider").get("decay").set(decay);
            context.completeStep();
        }
    }
}

