/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.spi.util.UnmodifiableDictionary;

public class ConfigAdminState
extends Observable
implements Serializable,
Service<ConfigAdminState> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"configadmin", "subsystemstate"});
    private final Map<String, Dictionary<String, String>> configurations = new LinkedHashMap<String, Dictionary<String, String>>();

    public static ServiceController<ConfigAdminState> addService(ServiceTarget serviceTarget) {
        ConfigAdminState state = new ConfigAdminState();
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)state);
        builder.setInitialMode(ServiceController.Mode.LAZY);
        return builder.install();
    }

    static ConfigAdminState getSubsystemState(OperationContext context) {
        ServiceController controller = context.getServiceRegistry(true).getService(SERVICE_NAME);
        return controller != null ? (ConfigAdminState)controller.getValue() : null;
    }

    ConfigAdminState() {
    }

    public ConfigAdminState getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getConfigurations() {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            Set<String> values = this.configurations.keySet();
            return Collections.unmodifiableSet(new HashSet<String>(values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.containsKey(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> getConfiguration(String pid) {
        Map<String, Dictionary<String, String>> map = this.configurations;
        synchronized (map) {
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> putConfiguration(String pid, Dictionary<String, String> props) {
        try {
            Map<String, Dictionary<String, String>> map = this.configurations;
            synchronized (map) {
                Dictionary<String, String> dictionary = this.configurations.put(pid, (Dictionary<String, String>)new UnmodifiableDictionary(props));
                return dictionary;
            }
        }
        finally {
            this.notifyObservers(new ChangeEvent(ChangeType.CONFIG, false, pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<String, String> removeConfiguration(String pid) {
        try {
            Map<String, Dictionary<String, String>> map = this.configurations;
            synchronized (map) {
                Dictionary<String, String> dictionary = this.configurations.remove(pid);
                return dictionary;
            }
        }
        finally {
            this.notifyObservers(new ChangeEvent(ChangeType.CONFIG, true, pid));
        }
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public static enum ChangeType {
        CONFIG;

    }

    public static class ChangeEvent {
        private final String id;
        private final boolean isRemoved;
        private final ChangeType type;

        public ChangeEvent(ChangeType type, boolean isRemoved, String id) {
            this.type = type;
            this.isRemoved = isRemoved;
            this.id = id;
        }

        public ChangeType getType() {
            return this.type;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public String getId() {
            return this.id;
        }
    }
}

