/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.Marshaller;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.w3c.dom.Node;

public class FastInfosetMarshaller
implements Marshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(FastInfosetMarshaller.class);

    @Override
    public void write(Object dataObject, OutputStream output) throws IOException {
        if (!(dataObject instanceof SOAPMessage)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_A_SOAPMESSAGE", (Object[])new Object[]{dataObject}));
        }
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)dataObject;
        if (soapMessage.getAttachments().hasNext()) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ATTACHMENTS_NOT_SUPPORTED_WITH_FASTINFOSET", (Object[])new Object[0]));
        }
        try {
            SOAPEnvelope soapEnv = soapMessage.getSOAPPart().getEnvelope();
            DOMDocumentSerializer serializer = new DOMDocumentSerializer();
            serializer.setOutputStream(output);
            serializer.serialize((Node)soapEnv);
        }
        catch (SOAPException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SERIALIZE_SOAP_ENVELOPE", (Object[])new Object[0]));
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

