/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.ignored;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ignored.IgnoreDomainResourceTypeResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainTypeResourceDefinition;
import org.jboss.dmr.ModelNode;

class IgnoredDomainTypeAddHandler
implements OperationStepHandler {
    IgnoredDomainTypeAddHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String type = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        if ("host".equals(type)) {
            throw HostControllerMessages.MESSAGES.cannotIgnoreTypeHost("host");
        }
        ModelNode names = IgnoredDomainTypeResourceDefinition.NAMES.validateOperation(operation);
        ModelNode wildcardNode = IgnoredDomainTypeResourceDefinition.WILDCARD.validateOperation(operation);
        Boolean wildcard = wildcardNode.isDefined() ? Boolean.valueOf(wildcardNode.asBoolean()) : null;
        IgnoreDomainResourceTypeResource resource = new IgnoreDomainResourceTypeResource(type, names, wildcard);
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
        boolean booting = context.isBooting();
        if (!booting) {
            context.reloadRequired();
        }
        if (context.completeStep() == OperationContext.ResultAction.KEEP) {
            if (booting) {
                resource.publish();
            }
        } else if (!booting) {
            context.revertReloadRequired();
        }
    }
}

