/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.singleton;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.service.ServiceProviderRegistry;
import org.jboss.as.clustering.service.ServiceProviderRegistryService;
import org.jboss.as.clustering.singleton.Singleton;
import org.jboss.as.clustering.singleton.SingletonElectionPolicy;
import org.jboss.as.clustering.singleton.SingletonLogger;
import org.jboss.as.clustering.singleton.SingletonMessages;
import org.jboss.as.clustering.singleton.SingletonRpcHandler;
import org.jboss.marshalling.ClassResolver;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class SingletonService<T extends Serializable>
extends AsynchronousService<T>
implements ServiceProviderRegistry.Listener,
SingletonRpcHandler<T>,
Singleton {
    public static final String DEFAULT_CONTAINER = "cluster";
    private final InjectedValue<ServiceProviderRegistry> registryRef = new InjectedValue();
    private final InjectedValue<GroupRpcDispatcher> dispatcherRef = new InjectedValue();
    private final Service<T> service;
    private final ServiceName serviceName;
    private final ServiceName singletonServiceName;
    private final AtomicBoolean master = new AtomicBoolean(false);
    volatile ServiceProviderRegistry registry;
    volatile GroupRpcDispatcher dispatcher;
    private volatile ClassResolver resolver;
    private volatile SingletonElectionPolicy electionPolicy;
    private volatile SingletonRpcHandler<T> handler;
    private volatile ServiceRegistry container;
    private volatile boolean restartOnMerge = true;

    public SingletonService(Service<T> service, ServiceName serviceName) {
        this.service = service;
        this.serviceName = serviceName.append(new String[]{"service"});
        this.singletonServiceName = serviceName;
    }

    public ServiceBuilder<T> build(ServiceContainer target) {
        return this.build(target, DEFAULT_CONTAINER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceBuilder<T> build(ServiceContainer target, String container) {
        ServiceName registryName = ServiceProviderRegistryService.getServiceName((String)container);
        ServiceContainer serviceContainer = target;
        synchronized (serviceContainer) {
            if (target.getService(registryName) == null) {
                new ServiceProviderRegistryService().build((ServiceTarget)target, container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            }
        }
        target.addService(this.serviceName, this.service).setInitialMode(ServiceController.Mode.NEVER).install();
        target.addService(this.singletonServiceName.append(new String[]{"singleton"}), (Service)new ValueService((Value)new ImmediateValue((Object)this))).addDependency(this.singletonServiceName).setInitialMode(ServiceController.Mode.PASSIVE).install();
        return target.addService(this.singletonServiceName, (Service)this).addDependency(ServiceProviderRegistryService.getServiceName((String)container), ServiceProviderRegistry.class, this.registryRef).addDependency(ServiceName.JBOSS.append(new String[]{DEFAULT_CONTAINER, container}), GroupRpcDispatcher.class, this.dispatcherRef);
    }

    public void start(StartContext context) throws StartException {
        this.container = context.getController().getServiceContainer();
        super.start(context);
    }

    protected void start() {
        this.dispatcher = (GroupRpcDispatcher)this.dispatcherRef.getValue();
        this.registry = (ServiceProviderRegistry)this.registryRef.getValue();
        String name = this.singletonServiceName.getCanonicalName();
        this.handler = new RpcHandler(this.dispatcher, name);
        if (this.resolver != null) {
            this.dispatcher.registerRPCHandler(name, (Object)this, this.resolver);
        } else {
            this.dispatcher.registerRPCHandler(name, (Object)this);
        }
        this.registry.register(name, (ServiceProviderRegistry.Listener)this);
    }

    protected void stop() {
        String name = this.singletonServiceName.getCanonicalName();
        this.registry.unregister(name);
        this.dispatcher.unregisterRPCHandler(name, (Object)this);
    }

    @Override
    public boolean isMaster() {
        return this.master.get();
    }

    public void setClassResolver(ClassResolver resolver) {
        this.resolver = resolver;
    }

    public void setElectionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
    }

    public void setRestartOnMerge(boolean restart) {
        this.restartOnMerge = restart;
    }

    public void serviceProvidersChanged(Set<ClusterNode> nodes, boolean merge) {
        if (this.elected(nodes)) {
            if (this.master.get()) {
                if (this.restartOnMerge && merge) {
                    this.stopOldMaster();
                    this.startNewMaster();
                }
            } else {
                SingletonLogger.ROOT_LOGGER.electedMaster(this.singletonServiceName.getCanonicalName());
                this.handler.stopOldMaster();
                this.startNewMaster();
            }
        } else if (this.master.get()) {
            SingletonLogger.ROOT_LOGGER.electedSlave(this.singletonServiceName.getCanonicalName());
            this.stopOldMaster();
        }
    }

    private boolean elected(Set<ClusterNode> candidates) {
        ClusterNode elected = this.election(candidates);
        SingletonLogger.ROOT_LOGGER.elected(elected.getName(), this.singletonServiceName.getCanonicalName());
        return elected != null ? elected.equals(this.dispatcher.getClusterNode()) : false;
    }

    private ClusterNode election(Set<ClusterNode> candidates) {
        List nodes = this.dispatcher.getClusterNodes();
        nodes.retainAll(candidates);
        if (nodes.isEmpty()) {
            return null;
        }
        return this.electionPolicy == null ? (ClusterNode)nodes.get(0) : this.electionPolicy.elect(nodes);
    }

    private void startNewMaster() {
        this.master.set(true);
        this.container.getRequiredService(this.serviceName).setMode(ServiceController.Mode.ACTIVE);
    }

    public T getValue() {
        AtomicReference<T> ref = this.getValueRef();
        return (T)(ref != null ? (Serializable)ref.get() : (Serializable)this.handler.getValueRef().get());
    }

    @Override
    public AtomicReference<T> getValueRef() {
        return this.master.get() ? new AtomicReference<Object>(this.service.getValue()) : null;
    }

    @Override
    public void stopOldMaster() {
        if (this.master.compareAndSet(true, false)) {
            this.container.getRequiredService(this.serviceName).setMode(ServiceController.Mode.NEVER);
        }
    }

    private class RpcHandler
    implements SingletonRpcHandler<T> {
        private final GroupRpcDispatcher dispatcher;
        private String name;

        RpcHandler(GroupRpcDispatcher dispatcher, String name) {
            this.dispatcher = dispatcher;
            this.name = name;
        }

        @Override
        public void stopOldMaster() {
            try {
                this.dispatcher.callMethodOnCluster(this.name, "stopOldMaster", new Object[0], new Class[0], true);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AtomicReference<T> getValueRef() {
            try {
                List results = this.dispatcher.callMethodOnCluster(this.name, "getValueRef", new Object[0], new Class[0], false);
                Iterator refs = results.iterator();
                while (refs.hasNext()) {
                    if (refs.next() != null) continue;
                    refs.remove();
                }
                int count = results.size();
                if (count != 1) {
                    throw SingletonMessages.MESSAGES.unexpectedResponseCount(count);
                }
                return (AtomicReference)results.get(0);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

