/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.repository.ArtifactProviderPlugin;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.XResourceBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;

final class ModuleIdentityArtifactProvider
extends AbstractService<Void>
implements ArtifactProviderPlugin {
    public static final ServiceName SERVICE_NAME = FrameworkBootstrapService.SERVICE_BASE_NAME.append(new String[]{"artifact.provider"});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedEnvironment = new InjectedValue();
    private ServiceRegistration registration;
    private File modulesDir;
    private File bundlesDir;

    static ServiceController<?> addService(ServiceTarget target) {
        ModuleIdentityArtifactProvider service = new ModuleIdentityArtifactProvider();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedEnvironment);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder.install();
    }

    private ModuleIdentityArtifactProvider() {
    }

    public void start(StartContext context) throws StartException {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
        this.registration = syscontext.registerService(ArtifactProviderPlugin.class.getName(), (Object)this, props);
        ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedEnvironment.getValue();
        this.modulesDir = serverEnvironment.getModulesDir();
        this.bundlesDir = serverEnvironment.getBundlesDir();
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        ArrayList<XIdentityCapability> result = new ArrayList<XIdentityCapability>();
        if ("module.identity".equals(namespace)) {
            String strval = (String)req.getAttributes().get("module.identity");
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString((String)strval);
            try {
                File contentFile = ModuleIdentityArtifactProvider.getRepositoryEntry(this.bundlesDir, moduleIdentifier);
                if (contentFile != null) {
                    URL baseURL = this.bundlesDir.toURI().toURL();
                    String contentPath = contentFile.toURI().toURL().toExternalForm();
                    contentPath = contentPath.substring(baseURL.toExternalForm().length());
                    XResource resource = XResourceBuilder.create((URL)baseURL, (String)contentPath).getResource();
                    result.add(resource.getIdentityCapability());
                } else {
                    contentFile = ModuleIdentityArtifactProvider.getRepositoryEntry(this.modulesDir, moduleIdentifier);
                    if (contentFile != null) {
                        URL baseURL = this.modulesDir.toURI().toURL();
                        String contentPath = contentFile.toURI().toURL().toExternalForm();
                        contentPath = contentPath.substring(baseURL.toExternalForm().length());
                        XResource resource = XResourceBuilder.create((URL)baseURL, (String)contentPath).getResource();
                        result.add(resource.getIdentityCapability());
                    }
                }
            }
            catch (RepositoryResolutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RepositoryResolutionException((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    static File getRepositoryEntry(File rootDir, ModuleIdentifier identifier) throws IOException {
        String identifierPath = identifier.getName().replace('.', '/') + "/" + identifier.getSlot();
        File entryDir = new File(rootDir + "/" + identifierPath);
        if (!entryDir.isDirectory()) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain directory: %s", entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot find jar in: %s", entryDir);
            return null;
        }
        if (files.length > 1) {
            OSGiLogger.ROOT_LOGGER.debugf("Multiple jars in: %s", entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            OSGiLogger.ROOT_LOGGER.debugf("File does not exist: %s", entryFile);
            return null;
        }
        return entryFile;
    }

    public String toString() {
        return ModuleIdentityArtifactProvider.class.getSimpleName();
    }
}

